/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.flow;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.flow.FlowControlHandler;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.ReferenceCountUtil;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Exchanger;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class FlowControlHandlerTest {
    private static EventLoopGroup GROUP;

    @BeforeAll
    public static void init() {
        GROUP = new NioEventLoopGroup();
    }

    @AfterAll
    public static void destroy() {
        GROUP.shutdownGracefully();
    }

    private static ByteBuf newOneMessage() {
        return Unpooled.wrappedBuffer((byte[])new byte[]{1});
    }

    private static Channel newServer(boolean autoRead, final ChannelHandler ... handlers) {
        Assertions.assertTrue((handlers.length >= 1 ? 1 : 0) != 0);
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)serverBootstrap.group(GROUP).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, (Object)autoRead).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChannelHandler[]{new OneByteToThreeStringsDecoder()});
                pipeline.addLast(handlers);
            }
        });
        return serverBootstrap.bind(0).syncUninterruptibly().channel();
    }

    private static Channel newClient(SocketAddress server) {
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(GROUP)).channel(NioSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)1000)).handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                Assertions.fail((String)"In this test the client is never receiving a message from the server.");
            }
        });
        return bootstrap.connect(server).syncUninterruptibly().channel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoReadingOn() throws Exception {
        final CountDownLatch latch = new CountDownLatch(3);
        ChannelInboundHandlerAdapter handler = new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                ReferenceCountUtil.release((Object)msg);
                ctx.channel().config().setAutoRead(false);
                latch.countDown();
            }
        };
        Channel server = FlowControlHandlerTest.newServer(true, new ChannelHandler[]{handler});
        Channel client = FlowControlHandlerTest.newClient(server.localAddress());
        try {
            client.writeAndFlush((Object)FlowControlHandlerTest.newOneMessage()).syncUninterruptibly();
            Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
        }
        finally {
            client.close();
            server.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoReadingOff() throws Exception {
        final Exchanger<Object> peerRef = new Exchanger<Object>();
        final CountDownLatch latch = new CountDownLatch(3);
        ChannelInboundHandlerAdapter handler = new ChannelInboundHandlerAdapter(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                peerRef.exchange(ctx.channel(), 1L, TimeUnit.SECONDS);
                ctx.fireChannelActive();
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                ReferenceCountUtil.release((Object)msg);
                latch.countDown();
            }
        };
        Channel server = FlowControlHandlerTest.newServer(false, new ChannelHandler[]{handler});
        Channel client = FlowControlHandlerTest.newClient(server.localAddress());
        try {
            Channel peer = peerRef.exchange(null, 1L, TimeUnit.SECONDS);
            client.writeAndFlush((Object)FlowControlHandlerTest.newOneMessage()).syncUninterruptibly();
            peer.read();
            Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
        }
        finally {
            client.close();
            server.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlowAutoReadOn() throws Exception {
        final CountDownLatch latch = new CountDownLatch(3);
        final Exchanger<Object> peerRef = new Exchanger<Object>();
        ChannelDuplexHandler handler = new ChannelDuplexHandler(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                peerRef.exchange(ctx.channel(), 1L, TimeUnit.SECONDS);
                super.channelActive(ctx);
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                ReferenceCountUtil.release((Object)msg);
                latch.countDown();
            }
        };
        final FlowControlHandler flow = new FlowControlHandler();
        Channel server = FlowControlHandlerTest.newServer(true, new ChannelHandler[]{flow, handler});
        Channel client = FlowControlHandlerTest.newClient(server.localAddress());
        try {
            Channel peer = peerRef.exchange(null, 1L, TimeUnit.SECONDS);
            client.writeAndFlush((Object)FlowControlHandlerTest.newOneMessage()).syncUninterruptibly();
            Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
            Assertions.assertTrue((boolean)((Boolean)peer.eventLoop().submit((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return flow.isQueueEmpty();
                }
            }).get()));
        }
        finally {
            client.close();
            server.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlowToggleAutoRead() throws Exception {
        final Exchanger<Object> peerRef = new Exchanger<Object>();
        final CountDownLatch msgRcvLatch1 = new CountDownLatch(1);
        final CountDownLatch msgRcvLatch2 = new CountDownLatch(1);
        final CountDownLatch msgRcvLatch3 = new CountDownLatch(1);
        final CountDownLatch setAutoReadLatch1 = new CountDownLatch(1);
        final CountDownLatch setAutoReadLatch2 = new CountDownLatch(1);
        ChannelInboundHandlerAdapter handler = new ChannelInboundHandlerAdapter(){
            private int msgRcvCount;
            private int expectedMsgCount;

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                peerRef.exchange(ctx.channel(), 1L, TimeUnit.SECONDS);
                ctx.fireChannelActive();
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws InterruptedException {
                ReferenceCountUtil.release((Object)msg);
                ctx.channel().config().setAutoRead(false);
                if (this.msgRcvCount++ != this.expectedMsgCount) {
                    return;
                }
                switch (this.msgRcvCount) {
                    case 1: {
                        msgRcvLatch1.countDown();
                        if (!setAutoReadLatch1.await(1L, TimeUnit.SECONDS)) break;
                        ++this.expectedMsgCount;
                        break;
                    }
                    case 2: {
                        msgRcvLatch2.countDown();
                        if (!setAutoReadLatch2.await(1L, TimeUnit.SECONDS)) break;
                        ++this.expectedMsgCount;
                        break;
                    }
                    default: {
                        msgRcvLatch3.countDown();
                    }
                }
            }
        };
        final FlowControlHandler flow = new FlowControlHandler();
        Channel server = FlowControlHandlerTest.newServer(true, new ChannelHandler[]{flow, handler});
        Channel client = FlowControlHandlerTest.newClient(server.localAddress());
        try {
            Channel peer = peerRef.exchange(null, 1L, TimeUnit.SECONDS);
            client.writeAndFlush((Object)FlowControlHandlerTest.newOneMessage()).syncUninterruptibly();
            Assertions.assertTrue((boolean)msgRcvLatch1.await(1L, TimeUnit.SECONDS));
            peer.config().setAutoRead(true);
            setAutoReadLatch1.countDown();
            Assertions.assertTrue((boolean)msgRcvLatch1.await(1L, TimeUnit.SECONDS));
            peer.config().setAutoRead(true);
            setAutoReadLatch2.countDown();
            Assertions.assertTrue((boolean)msgRcvLatch3.await(1L, TimeUnit.SECONDS));
            Assertions.assertTrue((boolean)((Boolean)peer.eventLoop().submit((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return flow.isQueueEmpty();
                }
            }).get()));
        }
        finally {
            client.close();
            server.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlowAutoReadOff() throws Exception {
        final Exchanger<Object> peerRef = new Exchanger<Object>();
        final CountDownLatch msgRcvLatch1 = new CountDownLatch(1);
        final CountDownLatch msgRcvLatch2 = new CountDownLatch(2);
        final CountDownLatch msgRcvLatch3 = new CountDownLatch(3);
        ChannelDuplexHandler handler = new ChannelDuplexHandler(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                ctx.fireChannelActive();
                peerRef.exchange(ctx.channel(), 1L, TimeUnit.SECONDS);
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                msgRcvLatch1.countDown();
                msgRcvLatch2.countDown();
                msgRcvLatch3.countDown();
            }
        };
        final FlowControlHandler flow = new FlowControlHandler();
        Channel server = FlowControlHandlerTest.newServer(false, new ChannelHandler[]{flow, handler});
        Channel client = FlowControlHandlerTest.newClient(server.localAddress());
        try {
            Channel peer = peerRef.exchange(null, 1L, TimeUnit.SECONDS);
            client.writeAndFlush((Object)FlowControlHandlerTest.newOneMessage()).syncUninterruptibly();
            peer.read();
            Assertions.assertTrue((boolean)msgRcvLatch1.await(1L, TimeUnit.SECONDS));
            peer.read();
            Assertions.assertTrue((boolean)msgRcvLatch2.await(1L, TimeUnit.SECONDS));
            peer.read();
            Assertions.assertTrue((boolean)msgRcvLatch3.await(1L, TimeUnit.SECONDS));
            Assertions.assertTrue((boolean)((Boolean)peer.eventLoop().submit((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return flow.isQueueEmpty();
                }
            }).get()));
        }
        finally {
            client.close();
            server.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlowAutoReadOffAndQueueNonEmpty() throws Exception {
        final Exchanger<Object> peerRef = new Exchanger<Object>();
        final CountDownLatch msgRcvLatch1 = new CountDownLatch(1);
        final CountDownLatch msgRcvLatch2 = new CountDownLatch(2);
        final CountDownLatch msgRcvLatch3 = new CountDownLatch(3);
        ChannelDuplexHandler handler = new ChannelDuplexHandler(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                ctx.fireChannelActive();
                peerRef.exchange(ctx.channel(), 1L, TimeUnit.SECONDS);
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                msgRcvLatch1.countDown();
                msgRcvLatch2.countDown();
                msgRcvLatch3.countDown();
            }
        };
        final FlowControlHandler flow = new FlowControlHandler();
        Channel server = FlowControlHandlerTest.newServer(false, new ChannelHandler[]{flow, handler});
        Channel client = FlowControlHandlerTest.newClient(server.localAddress());
        try {
            Channel peer = peerRef.exchange(null, 1L, TimeUnit.SECONDS);
            client.writeAndFlush((Object)FlowControlHandlerTest.newOneMessage()).syncUninterruptibly();
            peer.read();
            Assertions.assertTrue((boolean)msgRcvLatch1.await(1L, TimeUnit.SECONDS));
            Assertions.assertFalse((boolean)((Boolean)peer.eventLoop().submit((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return flow.isQueueEmpty();
                }
            }).get()));
            client.writeAndFlush((Object)FlowControlHandlerTest.newOneMessage()).syncUninterruptibly();
            peer.read();
            Assertions.assertTrue((boolean)msgRcvLatch2.await(1L, TimeUnit.SECONDS));
            peer.read();
            Assertions.assertTrue((boolean)msgRcvLatch3.await(1L, TimeUnit.SECONDS));
            Assertions.assertTrue((boolean)((Boolean)peer.eventLoop().submit((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return flow.isQueueEmpty();
                }
            }).get()));
        }
        finally {
            client.close();
            server.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReentranceNotCausesNPE() throws Throwable {
        final Exchanger<Object> peerRef = new Exchanger<Object>();
        final CountDownLatch latch = new CountDownLatch(3);
        final AtomicReference causeRef = new AtomicReference();
        ChannelDuplexHandler handler = new ChannelDuplexHandler(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                ctx.fireChannelActive();
                peerRef.exchange(ctx.channel(), 1L, TimeUnit.SECONDS);
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                latch.countDown();
                ctx.read();
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                causeRef.set(cause);
            }
        };
        final FlowControlHandler flow = new FlowControlHandler();
        Channel server = FlowControlHandlerTest.newServer(false, new ChannelHandler[]{flow, handler});
        Channel client = FlowControlHandlerTest.newClient(server.localAddress());
        try {
            Channel peer = peerRef.exchange(null, 1L, TimeUnit.SECONDS);
            client.writeAndFlush((Object)FlowControlHandlerTest.newOneMessage()).syncUninterruptibly();
            peer.read();
            Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
            Assertions.assertTrue((boolean)((Boolean)peer.eventLoop().submit((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return flow.isQueueEmpty();
                }
            }).get()));
            Throwable cause = (Throwable)causeRef.get();
            if (cause != null) {
                throw cause;
            }
        }
        finally {
            client.close();
            server.close();
        }
    }

    @Test
    public void testSwallowedReadComplete() throws Exception {
        long delayMillis = 100L;
        final LinkedBlockingQueue userEvents = new LinkedBlockingQueue();
        EmbeddedChannel channel = new EmbeddedChannel(false, false, new ChannelHandler[]{new FlowControlHandler(), new IdleStateHandler(100L, 0L, 0L, TimeUnit.MILLISECONDS), new ChannelInboundHandlerAdapter(){

            public void channelActive(ChannelHandlerContext ctx) {
                ctx.fireChannelActive();
                ctx.read();
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                ctx.fireChannelRead(msg);
                ctx.read();
            }

            public void channelReadComplete(ChannelHandlerContext ctx) {
                ctx.fireChannelReadComplete();
                ctx.read();
            }

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                if (evt instanceof IdleStateEvent) {
                    userEvents.add((IdleStateEvent)evt);
                }
                ctx.fireUserEventTriggered(evt);
            }
        }});
        channel.config().setAutoRead(false);
        Assertions.assertFalse((boolean)channel.config().isAutoRead());
        channel.register();
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.EMPTY_BUFFER}));
        channel.flushInbound();
        Assertions.assertEquals((Object)Unpooled.EMPTY_BUFFER, (Object)channel.readInbound());
        channel.flushInbound();
        Assertions.assertNull((Object)channel.readInbound());
        Thread.sleep(120L);
        channel.runPendingTasks();
        Assertions.assertEquals((Object)IdleStateEvent.FIRST_READER_IDLE_STATE_EVENT, userEvents.poll());
        Assertions.assertFalse((boolean)channel.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveFlowControl() throws Exception {
        final Exchanger<Object> peerRef = new Exchanger<Object>();
        final CountDownLatch latch = new CountDownLatch(3);
        ChannelDuplexHandler handler = new ChannelDuplexHandler(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                peerRef.exchange(ctx.channel(), 1L, TimeUnit.SECONDS);
                ctx.read();
                super.channelActive(ctx);
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                latch.countDown();
                super.channelRead(ctx, msg);
            }
        };
        final FlowControlHandler flow = new FlowControlHandler(){
            private int num;

            public void channelRead(final ChannelHandlerContext ctx, Object msg) throws Exception {
                super.channelRead(ctx, msg);
                ++this.num;
                if (this.num >= 3) {
                    18 handler = this;
                    ctx.channel().eventLoop().execute(new Runnable((ChannelHandler)handler){
                        final /* synthetic */ ChannelHandler val$handler;
                        {
                            this.val$handler = channelHandler;
                        }

                        @Override
                        public void run() {
                            ctx.pipeline().remove(this.val$handler);
                        }
                    });
                }
            }
        };
        ChannelInboundHandlerAdapter tail = new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                ReferenceCountUtil.release((Object)msg);
            }
        };
        Channel server = FlowControlHandlerTest.newServer(false, new ChannelHandler[]{flow, handler, tail});
        Channel client = FlowControlHandlerTest.newClient(server.localAddress());
        try {
            Channel peer = peerRef.exchange(null, 1L, TimeUnit.SECONDS);
            client.writeAndFlush((Object)FlowControlHandlerTest.newOneMessage()).sync();
            Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
            Assertions.assertTrue((boolean)((Boolean)peer.eventLoop().submit((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return flow.isQueueEmpty();
                }
            }).get()));
        }
        finally {
            client.close();
            server.close();
        }
    }

    private static final class OneByteToThreeStringsDecoder
    extends ByteToMessageDecoder {
        private OneByteToThreeStringsDecoder() {
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
            for (int i = 0; i < in.readableBytes(); ++i) {
                out.add("1");
                out.add("2");
                out.add("3");
            }
            in.readerIndex(in.readableBytes());
        }
    }
}

