/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.parser.netty;

import io.moquette.parser.netty.DemuxEncoder;
import io.moquette.parser.netty.Utils;
import io.moquette.proto.messages.AbstractMessage;
import io.moquette.proto.messages.UnsubscribeMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;

class UnsubscribeEncoder
extends DemuxEncoder<UnsubscribeMessage> {
    UnsubscribeEncoder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext chc, UnsubscribeMessage message, ByteBuf out) {
        if (message.topicFilters().isEmpty()) {
            throw new IllegalArgumentException("Found an unsubscribe message with empty topics");
        }
        if (message.getQos() != AbstractMessage.QOSType.LEAST_ONE) {
            throw new IllegalArgumentException("Expected a message with QOS 1, found " + message.getQos());
        }
        ByteBuf variableHeaderBuff = chc.alloc().buffer(4);
        ByteBuf buff = null;
        try {
            variableHeaderBuff.writeShort(message.getMessageID().intValue());
            for (String topic : message.topicFilters()) {
                variableHeaderBuff.writeBytes(Utils.encodeString(topic));
            }
            int variableHeaderSize = variableHeaderBuff.readableBytes();
            byte flags = Utils.encodeFlags((AbstractMessage)message);
            buff = chc.alloc().buffer(2 + variableHeaderSize);
            buff.writeByte(0xA0 | flags);
            buff.writeBytes(Utils.encodeRemainingLength(variableHeaderSize));
            buff.writeBytes(variableHeaderBuff);
            out.writeBytes(buff);
        }
        finally {
            variableHeaderBuff.release();
            buff.release();
        }
    }
}

