/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.parser.netty;

import io.moquette.parser.netty.DemuxEncoder;
import io.moquette.parser.netty.Utils;
import io.moquette.proto.messages.AbstractMessage;
import io.moquette.proto.messages.SubscribeMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;

class SubscribeEncoder
extends DemuxEncoder<SubscribeMessage> {
    SubscribeEncoder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext chc, SubscribeMessage message, ByteBuf out) {
        if (message.subscriptions().isEmpty()) {
            throw new IllegalArgumentException("Found a subscribe message with empty topics");
        }
        if (message.getQos() != AbstractMessage.QOSType.LEAST_ONE) {
            throw new IllegalArgumentException("Expected a message with QOS 1, found " + message.getQos());
        }
        ByteBuf variableHeaderBuff = chc.alloc().buffer(4);
        ByteBuf buff = null;
        try {
            variableHeaderBuff.writeShort(message.getMessageID().intValue());
            for (SubscribeMessage.Couple c : message.subscriptions()) {
                variableHeaderBuff.writeBytes(Utils.encodeString(c.topicFilter));
                variableHeaderBuff.writeByte((int)c.qos);
            }
            int variableHeaderSize = variableHeaderBuff.readableBytes();
            byte flags = Utils.encodeFlags((AbstractMessage)message);
            buff = chc.alloc().buffer(2 + variableHeaderSize);
            buff.writeByte(0x80 | flags);
            buff.writeBytes(Utils.encodeRemainingLength(variableHeaderSize));
            buff.writeBytes(variableHeaderBuff);
            out.writeBytes(buff);
        }
        finally {
            variableHeaderBuff.release();
            buff.release();
        }
    }
}

