/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.parser.netty;

import io.moquette.parser.netty.DemuxDecoder;
import io.moquette.parser.netty.Utils;
import io.moquette.proto.messages.AbstractMessage;
import io.moquette.proto.messages.PublishMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.util.AttributeMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PublishDecoder
extends DemuxDecoder {
    private static Logger LOG = LoggerFactory.getLogger(PublishDecoder.class);

    PublishDecoder() {
    }

    @Override
    void decode(AttributeMap ctx, ByteBuf in, List<Object> out) throws Exception {
        LOG.debug("decode invoked with buffer {}", (Object)in);
        in.resetReaderIndex();
        int startPos = in.readerIndex();
        PublishMessage message = new PublishMessage();
        if (!this.decodeCommonHeader((AbstractMessage)message, in)) {
            LOG.debug("decode ask for more data after {}", (Object)in);
            in.resetReaderIndex();
            return;
        }
        if (Utils.isMQTT3_1_1(ctx)) {
            if (message.getQos() == AbstractMessage.QOSType.MOST_ONE && message.isDupFlag()) {
                throw new CorruptedFrameException("Received a PUBLISH with QoS=0 & DUP = 1, MQTT 3.1.1 violation");
            }
            if (message.getQos() == AbstractMessage.QOSType.RESERVED) {
                throw new CorruptedFrameException("Received a PUBLISH with QoS flags setted 10 b11, MQTT 3.1.1 violation");
            }
        }
        int remainingLength = message.getRemainingLength();
        String topic = Utils.decodeString(in);
        if (topic == null) {
            in.resetReaderIndex();
            return;
        }
        if (topic.contains("+") || topic.contains("#")) {
            throw new CorruptedFrameException("Received a PUBLISH with topic containing wild card chars, topic: " + topic);
        }
        if (topic.length() == 0) {
            throw new CorruptedFrameException("Received a PUBLISH with topic without any character");
        }
        message.setTopicName(topic);
        if (message.getQos() == AbstractMessage.QOSType.LEAST_ONE || message.getQos() == AbstractMessage.QOSType.EXACTLY_ONCE) {
            message.setMessageID(Integer.valueOf(in.readUnsignedShort()));
        }
        int stopPos = in.readerIndex();
        int payloadSize = remainingLength - (stopPos - startPos - 2) + (Utils.numBytesToEncode(remainingLength) - 1);
        if (in.readableBytes() < payloadSize) {
            in.resetReaderIndex();
            return;
        }
        ByteBuf bb = Unpooled.buffer((int)payloadSize);
        in.readBytes(bb);
        message.setPayload(bb.nioBuffer());
        out.add(message);
    }
}

