/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.parser.netty;

import io.moquette.parser.netty.ConnAckDecoder;
import io.moquette.parser.netty.ConnectDecoder;
import io.moquette.parser.netty.DemuxDecoder;
import io.moquette.parser.netty.DisconnectDecoder;
import io.moquette.parser.netty.PingReqDecoder;
import io.moquette.parser.netty.PingRespDecoder;
import io.moquette.parser.netty.PubAckDecoder;
import io.moquette.parser.netty.PubCompDecoder;
import io.moquette.parser.netty.PubRecDecoder;
import io.moquette.parser.netty.PubRelDecoder;
import io.moquette.parser.netty.PublishDecoder;
import io.moquette.parser.netty.SubAckDecoder;
import io.moquette.parser.netty.SubscribeDecoder;
import io.moquette.parser.netty.UnsubAckDecoder;
import io.moquette.parser.netty.UnsubscribeDecoder;
import io.moquette.parser.netty.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.util.AttributeKey;
import io.netty.util.AttributeMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MQTTDecoder
extends ByteToMessageDecoder {
    static final AttributeKey<Integer> PROTOCOL_VERSION = AttributeKey.valueOf((String)"version");
    private final Map<Byte, DemuxDecoder> m_decoderMap = new HashMap<Byte, DemuxDecoder>();

    public MQTTDecoder() {
        this.m_decoderMap.put((byte)1, new ConnectDecoder());
        this.m_decoderMap.put((byte)2, new ConnAckDecoder());
        this.m_decoderMap.put((byte)3, new PublishDecoder());
        this.m_decoderMap.put((byte)4, new PubAckDecoder());
        this.m_decoderMap.put((byte)8, new SubscribeDecoder());
        this.m_decoderMap.put((byte)9, new SubAckDecoder());
        this.m_decoderMap.put((byte)10, new UnsubscribeDecoder());
        this.m_decoderMap.put((byte)14, new DisconnectDecoder());
        this.m_decoderMap.put((byte)12, new PingReqDecoder());
        this.m_decoderMap.put((byte)13, new PingRespDecoder());
        this.m_decoderMap.put((byte)11, new UnsubAckDecoder());
        this.m_decoderMap.put((byte)7, new PubCompDecoder());
        this.m_decoderMap.put((byte)5, new PubRecDecoder());
        this.m_decoderMap.put((byte)6, new PubRelDecoder());
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        in.markReaderIndex();
        if (!Utils.checkHeaderAvailability(in)) {
            in.resetReaderIndex();
            return;
        }
        in.resetReaderIndex();
        byte messageType = Utils.readMessageType(in);
        DemuxDecoder decoder = this.m_decoderMap.get(messageType);
        if (decoder == null) {
            throw new CorruptedFrameException("Can't find any suitable decoder for message type: " + messageType);
        }
        decoder.decode((AttributeMap)ctx, in, out);
    }
}

