/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import io.lettuce.core.json.DelegateJsonArray;
import io.lettuce.core.json.DelegateJsonObject;
import io.lettuce.core.json.DelegateJsonValue;
import io.lettuce.core.json.JsonArray;
import io.lettuce.core.json.JsonObject;
import io.lettuce.core.json.JsonParser;
import io.lettuce.core.json.JsonValue;
import io.lettuce.core.json.RedisJsonException;
import io.lettuce.core.json.UnproccessedJsonValue;
import java.io.IOException;
import java.nio.ByteBuffer;

public class DefaultJsonParser
implements JsonParser {
    @Override
    public JsonValue loadJsonValue(ByteBuffer bytes) {
        return new UnproccessedJsonValue(bytes, this);
    }

    @Override
    public JsonValue createJsonValue(ByteBuffer bytes) {
        return this.parse(bytes);
    }

    @Override
    public JsonValue createJsonValue(String value) {
        return this.parse(value);
    }

    @Override
    public JsonObject createJsonObject() {
        return new DelegateJsonObject();
    }

    @Override
    public JsonArray createJsonArray() {
        return new DelegateJsonArray();
    }

    @Override
    public JsonValue fromObject(Object object) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode root = objectMapper.valueToTree(object);
            return DelegateJsonValue.wrap(root);
        }
        catch (IllegalArgumentException e) {
            throw new RedisJsonException("Failed to process the provided object as JSON", e);
        }
    }

    private JsonValue parse(String value) {
        if (value == null) {
            return DelegateJsonValue.wrap((JsonNode)NullNode.getInstance());
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode root = mapper.readTree(value);
            return DelegateJsonValue.wrap(root);
        }
        catch (JsonProcessingException e) {
            throw new RedisJsonException("Failed to process the provided value as JSON: " + String.format("%.50s", value) + "...", e);
        }
    }

    private JsonValue parse(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return DelegateJsonValue.wrap((JsonNode)NullNode.getInstance());
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            JsonNode root = mapper.readTree(bytes);
            return DelegateJsonValue.wrap(root);
        }
        catch (IOException e) {
            throw new RedisJsonException("Failed to process the provided value as JSON", e);
        }
    }
}

