/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="NetworkDeviceData provides network-related details for the allocated device. This information may be filled by drivers or other components to configure or identify the device within a network context.")
public class V1beta2NetworkDeviceData {
    public static final String SERIALIZED_NAME_HARDWARE_ADDRESS = "hardwareAddress";
    @SerializedName(value="hardwareAddress")
    @Nullable
    private String hardwareAddress;
    public static final String SERIALIZED_NAME_INTERFACE_NAME = "interfaceName";
    @SerializedName(value="interfaceName")
    @Nullable
    private String interfaceName;
    public static final String SERIALIZED_NAME_IPS = "ips";
    @SerializedName(value="ips")
    @Nullable
    private List<String> ips = new ArrayList<String>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1beta2NetworkDeviceData hardwareAddress(@Nullable String hardwareAddress) {
        this.hardwareAddress = hardwareAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="HardwareAddress represents the hardware address (e.g. MAC Address) of the device's network interface.  Must not be longer than 128 characters.")
    public String getHardwareAddress() {
        return this.hardwareAddress;
    }

    public void setHardwareAddress(@Nullable String hardwareAddress) {
        this.hardwareAddress = hardwareAddress;
    }

    public V1beta2NetworkDeviceData interfaceName(@Nullable String interfaceName) {
        this.interfaceName = interfaceName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="InterfaceName specifies the name of the network interface associated with the allocated device. This might be the name of a physical or virtual network interface being configured in the pod.  Must not be longer than 256 characters.")
    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(@Nullable String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public V1beta2NetworkDeviceData ips(@Nullable List<String> ips) {
        this.ips = ips;
        return this;
    }

    public V1beta2NetworkDeviceData addIpsItem(String ipsItem) {
        if (this.ips == null) {
            this.ips = new ArrayList<String>();
        }
        this.ips.add(ipsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IPs lists the network addresses assigned to the device's network interface. This can include both IPv4 and IPv6 addresses. The IPs are in the CIDR notation, which includes both the address and the associated subnet mask. e.g.: \"192.0.2.5/24\" for IPv4 and \"2001:db8::5/64\" for IPv6.")
    public List<String> getIps() {
        return this.ips;
    }

    public void setIps(@Nullable List<String> ips) {
        this.ips = ips;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta2NetworkDeviceData v1beta2NetworkDeviceData = (V1beta2NetworkDeviceData)o;
        return Objects.equals(this.hardwareAddress, v1beta2NetworkDeviceData.hardwareAddress) && Objects.equals(this.interfaceName, v1beta2NetworkDeviceData.interfaceName) && Objects.equals(this.ips, v1beta2NetworkDeviceData.ips);
    }

    public int hashCode() {
        return Objects.hash(this.hardwareAddress, this.interfaceName, this.ips);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta2NetworkDeviceData {\n");
        sb.append("    hardwareAddress: ").append(this.toIndentedString(this.hardwareAddress)).append("\n");
        sb.append("    interfaceName: ").append(this.toIndentedString(this.interfaceName)).append("\n");
        sb.append("    ips: ").append(this.toIndentedString(this.ips)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1beta2NetworkDeviceData is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1beta2NetworkDeviceData` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_HARDWARE_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_HARDWARE_ADDRESS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HARDWARE_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `hardwareAddress` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HARDWARE_ADDRESS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INTERFACE_NAME) != null && !jsonObj.get(SERIALIZED_NAME_INTERFACE_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INTERFACE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `interfaceName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INTERFACE_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IPS) != null && !jsonObj.get(SERIALIZED_NAME_IPS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IPS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `ips` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IPS).toString()));
        }
    }

    public static V1beta2NetworkDeviceData fromJson(String jsonString) throws IOException {
        return (V1beta2NetworkDeviceData)JSON.getGson().fromJson(jsonString, V1beta2NetworkDeviceData.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_HARDWARE_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_INTERFACE_NAME);
        openapiFields.add(SERIALIZED_NAME_IPS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1beta2NetworkDeviceData.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1beta2NetworkDeviceData.class));
            return new TypeAdapter<V1beta2NetworkDeviceData>(){

                public void write(JsonWriter out, V1beta2NetworkDeviceData value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1beta2NetworkDeviceData read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1beta2NetworkDeviceData.validateJsonElement(jsonElement);
                    return (V1beta2NetworkDeviceData)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

