/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="VolumeMountStatus shows status of volume mounts.")
public class V1VolumeMountStatus {
    public static final String SERIALIZED_NAME_MOUNT_PATH = "mountPath";
    @SerializedName(value="mountPath")
    @Nonnull
    private String mountPath;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    @Nullable
    private Boolean readOnly;
    public static final String SERIALIZED_NAME_RECURSIVE_READ_ONLY = "recursiveReadOnly";
    @SerializedName(value="recursiveReadOnly")
    @Nullable
    private String recursiveReadOnly;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1VolumeMountStatus mountPath(@Nonnull String mountPath) {
        this.mountPath = mountPath;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="MountPath corresponds to the original VolumeMount.")
    public String getMountPath() {
        return this.mountPath;
    }

    public void setMountPath(@Nonnull String mountPath) {
        this.mountPath = mountPath;
    }

    public V1VolumeMountStatus name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Name corresponds to the name of the original VolumeMount.")
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public V1VolumeMountStatus readOnly(@Nullable Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ReadOnly corresponds to the original VolumeMount.")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(@Nullable Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1VolumeMountStatus recursiveReadOnly(@Nullable String recursiveReadOnly) {
        this.recursiveReadOnly = recursiveReadOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RecursiveReadOnly must be set to Disabled, Enabled, or unspecified (for non-readonly mounts). An IfPossible value in the original VolumeMount must be translated to Disabled or Enabled, depending on the mount result.")
    public String getRecursiveReadOnly() {
        return this.recursiveReadOnly;
    }

    public void setRecursiveReadOnly(@Nullable String recursiveReadOnly) {
        this.recursiveReadOnly = recursiveReadOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1VolumeMountStatus v1VolumeMountStatus = (V1VolumeMountStatus)o;
        return Objects.equals(this.mountPath, v1VolumeMountStatus.mountPath) && Objects.equals(this.name, v1VolumeMountStatus.name) && Objects.equals(this.readOnly, v1VolumeMountStatus.readOnly) && Objects.equals(this.recursiveReadOnly, v1VolumeMountStatus.recursiveReadOnly);
    }

    public int hashCode() {
        return Objects.hash(this.mountPath, this.name, this.readOnly, this.recursiveReadOnly);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1VolumeMountStatus {\n");
        sb.append("    mountPath: ").append(this.toIndentedString(this.mountPath)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    recursiveReadOnly: ").append(this.toIndentedString(this.recursiveReadOnly)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1VolumeMountStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1VolumeMountStatus` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_MOUNT_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `mountPath` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MOUNT_PATH).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RECURSIVE_READ_ONLY) != null && !jsonObj.get(SERIALIZED_NAME_RECURSIVE_READ_ONLY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RECURSIVE_READ_ONLY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `recursiveReadOnly` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECURSIVE_READ_ONLY).toString()));
        }
    }

    public static V1VolumeMountStatus fromJson(String jsonString) throws IOException {
        return (V1VolumeMountStatus)JSON.getGson().fromJson(jsonString, V1VolumeMountStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_MOUNT_PATH);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_READ_ONLY);
        openapiFields.add(SERIALIZED_NAME_RECURSIVE_READ_ONLY);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_MOUNT_PATH);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1VolumeMountStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1VolumeMountStatus.class));
            return new TypeAdapter<V1VolumeMountStatus>(){

                public void write(JsonWriter out, V1VolumeMountStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1VolumeMountStatus read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1VolumeMountStatus.validateJsonElement(jsonElement);
                    return (V1VolumeMountStatus)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

