/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="VolumeError captures an error encountered during a volume operation.")
public class V1VolumeError {
    public static final String SERIALIZED_NAME_ERROR_CODE = "errorCode";
    @SerializedName(value="errorCode")
    @Nullable
    private Integer errorCode;
    public static final String SERIALIZED_NAME_MESSAGE = "message";
    @SerializedName(value="message")
    @Nullable
    private String message;
    public static final String SERIALIZED_NAME_TIME = "time";
    @SerializedName(value="time")
    @Nullable
    private OffsetDateTime time;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1VolumeError errorCode(@Nullable Integer errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="errorCode is a numeric gRPC code representing the error encountered during Attach or Detach operations.  This is an optional, alpha field that requires the MutableCSINodeAllocatableCount feature gate being enabled to be set.")
    public Integer getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(@Nullable Integer errorCode) {
        this.errorCode = errorCode;
    }

    public V1VolumeError message(@Nullable String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="message represents the error encountered during Attach or Detach operation. This string may be logged, so it should not contain sensitive information.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(@Nullable String message) {
        this.message = message;
    }

    public V1VolumeError time(@Nullable OffsetDateTime time) {
        this.time = time;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="time represents the time the error was encountered.")
    public OffsetDateTime getTime() {
        return this.time;
    }

    public void setTime(@Nullable OffsetDateTime time) {
        this.time = time;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1VolumeError v1VolumeError = (V1VolumeError)o;
        return Objects.equals(this.errorCode, v1VolumeError.errorCode) && Objects.equals(this.message, v1VolumeError.message) && Objects.equals(this.time, v1VolumeError.time);
    }

    public int hashCode() {
        return Objects.hash(this.errorCode, this.message, this.time);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1VolumeError {\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1VolumeError is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1VolumeError` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_MESSAGE) != null && !jsonObj.get(SERIALIZED_NAME_MESSAGE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MESSAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `message` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MESSAGE).toString()));
        }
    }

    public static V1VolumeError fromJson(String jsonString) throws IOException {
        return (V1VolumeError)JSON.getGson().fromJson(jsonString, V1VolumeError.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ERROR_CODE);
        openapiFields.add(SERIALIZED_NAME_MESSAGE);
        openapiFields.add(SERIALIZED_NAME_TIME);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1VolumeError.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1VolumeError.class));
            return new TypeAdapter<V1VolumeError>(){

                public void write(JsonWriter out, V1VolumeError value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1VolumeError read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1VolumeError.validateJsonElement(jsonElement);
                    return (V1VolumeError)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

