/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1BoundObjectReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="TokenRequestSpec contains client provided parameters of a token request.")
public class V1TokenRequestSpec {
    public static final String SERIALIZED_NAME_AUDIENCES = "audiences";
    @SerializedName(value="audiences")
    @Nonnull
    private List<String> audiences = new ArrayList<String>();
    public static final String SERIALIZED_NAME_BOUND_OBJECT_REF = "boundObjectRef";
    @SerializedName(value="boundObjectRef")
    @Nullable
    private V1BoundObjectReference boundObjectRef;
    public static final String SERIALIZED_NAME_EXPIRATION_SECONDS = "expirationSeconds";
    @SerializedName(value="expirationSeconds")
    @Nullable
    private Long expirationSeconds;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1TokenRequestSpec audiences(@Nonnull List<String> audiences) {
        this.audiences = audiences;
        return this;
    }

    public V1TokenRequestSpec addAudiencesItem(String audiencesItem) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.add(audiencesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Audiences are the intendend audiences of the token. A recipient of a token must identify themself with an identifier in the list of audiences of the token, and otherwise should reject the token. A token issued for multiple audiences may be used to authenticate against any of the audiences listed but implies a high degree of trust between the target audiences.")
    public List<String> getAudiences() {
        return this.audiences;
    }

    public void setAudiences(@Nonnull List<String> audiences) {
        this.audiences = audiences;
    }

    public V1TokenRequestSpec boundObjectRef(@Nullable V1BoundObjectReference boundObjectRef) {
        this.boundObjectRef = boundObjectRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1BoundObjectReference getBoundObjectRef() {
        return this.boundObjectRef;
    }

    public void setBoundObjectRef(@Nullable V1BoundObjectReference boundObjectRef) {
        this.boundObjectRef = boundObjectRef;
    }

    public V1TokenRequestSpec expirationSeconds(@Nullable Long expirationSeconds) {
        this.expirationSeconds = expirationSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ExpirationSeconds is the requested duration of validity of the request. The token issuer may return a token with a different validity duration so a client needs to check the 'expiration' field in a response.")
    public Long getExpirationSeconds() {
        return this.expirationSeconds;
    }

    public void setExpirationSeconds(@Nullable Long expirationSeconds) {
        this.expirationSeconds = expirationSeconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1TokenRequestSpec v1TokenRequestSpec = (V1TokenRequestSpec)o;
        return Objects.equals(this.audiences, v1TokenRequestSpec.audiences) && Objects.equals(this.boundObjectRef, v1TokenRequestSpec.boundObjectRef) && Objects.equals(this.expirationSeconds, v1TokenRequestSpec.expirationSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.audiences, this.boundObjectRef, this.expirationSeconds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1TokenRequestSpec {\n");
        sb.append("    audiences: ").append(this.toIndentedString(this.audiences)).append("\n");
        sb.append("    boundObjectRef: ").append(this.toIndentedString(this.boundObjectRef)).append("\n");
        sb.append("    expirationSeconds: ").append(this.toIndentedString(this.expirationSeconds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1TokenRequestSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1TokenRequestSpec` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_AUDIENCES) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_AUDIENCES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `audiences` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AUDIENCES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BOUND_OBJECT_REF) != null && !jsonObj.get(SERIALIZED_NAME_BOUND_OBJECT_REF).isJsonNull()) {
            V1BoundObjectReference.validateJsonElement(jsonObj.get(SERIALIZED_NAME_BOUND_OBJECT_REF));
        }
    }

    public static V1TokenRequestSpec fromJson(String jsonString) throws IOException {
        return (V1TokenRequestSpec)JSON.getGson().fromJson(jsonString, V1TokenRequestSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AUDIENCES);
        openapiFields.add(SERIALIZED_NAME_BOUND_OBJECT_REF);
        openapiFields.add(SERIALIZED_NAME_EXPIRATION_SECONDS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_AUDIENCES);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1TokenRequestSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1TokenRequestSpec.class));
            return new TypeAdapter<V1TokenRequestSpec>(){

                public void write(JsonWriter out, V1TokenRequestSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1TokenRequestSpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1TokenRequestSpec.validateJsonElement(jsonElement);
                    return (V1TokenRequestSpec)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

