/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1ObjectReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="EndpointAddress is a tuple that describes single IP address. Deprecated: This API is deprecated in v1.33+.")
public class V1EndpointAddress {
    public static final String SERIALIZED_NAME_HOSTNAME = "hostname";
    @SerializedName(value="hostname")
    @Nullable
    private String hostname;
    public static final String SERIALIZED_NAME_IP = "ip";
    @SerializedName(value="ip")
    @Nonnull
    private String ip;
    public static final String SERIALIZED_NAME_NODE_NAME = "nodeName";
    @SerializedName(value="nodeName")
    @Nullable
    private String nodeName;
    public static final String SERIALIZED_NAME_TARGET_REF = "targetRef";
    @SerializedName(value="targetRef")
    @Nullable
    private V1ObjectReference targetRef;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1EndpointAddress hostname(@Nullable String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Hostname of this endpoint")
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(@Nullable String hostname) {
        this.hostname = hostname;
    }

    public V1EndpointAddress ip(@Nonnull String ip) {
        this.ip = ip;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The IP of this endpoint. May not be loopback (127.0.0.0/8 or ::1), link-local (169.254.0.0/16 or fe80::/10), or link-local multicast (224.0.0.0/24 or ff02::/16).")
    public String getIp() {
        return this.ip;
    }

    public void setIp(@Nonnull String ip) {
        this.ip = ip;
    }

    public V1EndpointAddress nodeName(@Nullable String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Node hosting this endpoint. This can be used to determine endpoints local to a node.")
    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(@Nullable String nodeName) {
        this.nodeName = nodeName;
    }

    public V1EndpointAddress targetRef(@Nullable V1ObjectReference targetRef) {
        this.targetRef = targetRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ObjectReference getTargetRef() {
        return this.targetRef;
    }

    public void setTargetRef(@Nullable V1ObjectReference targetRef) {
        this.targetRef = targetRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1EndpointAddress v1EndpointAddress = (V1EndpointAddress)o;
        return Objects.equals(this.hostname, v1EndpointAddress.hostname) && Objects.equals(this.ip, v1EndpointAddress.ip) && Objects.equals(this.nodeName, v1EndpointAddress.nodeName) && Objects.equals(this.targetRef, v1EndpointAddress.targetRef);
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.ip, this.nodeName, this.targetRef);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1EndpointAddress {\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    ip: ").append(this.toIndentedString(this.ip)).append("\n");
        sb.append("    nodeName: ").append(this.toIndentedString(this.nodeName)).append("\n");
        sb.append("    targetRef: ").append(this.toIndentedString(this.targetRef)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1EndpointAddress is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1EndpointAddress` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_HOSTNAME) != null && !jsonObj.get(SERIALIZED_NAME_HOSTNAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HOSTNAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `hostname` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOSTNAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_IP).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ip` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IP).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NODE_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NODE_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NODE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `nodeName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NODE_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TARGET_REF) != null && !jsonObj.get(SERIALIZED_NAME_TARGET_REF).isJsonNull()) {
            V1ObjectReference.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TARGET_REF));
        }
    }

    public static V1EndpointAddress fromJson(String jsonString) throws IOException {
        return (V1EndpointAddress)JSON.getGson().fromJson(jsonString, V1EndpointAddress.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_HOSTNAME);
        openapiFields.add(SERIALIZED_NAME_IP);
        openapiFields.add(SERIALIZED_NAME_NODE_NAME);
        openapiFields.add(SERIALIZED_NAME_TARGET_REF);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_IP);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1EndpointAddress.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1EndpointAddress.class));
            return new TypeAdapter<V1EndpointAddress>(){

                public void write(JsonWriter out, V1EndpointAddress value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1EndpointAddress read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1EndpointAddress.validateJsonElement(jsonElement);
                    return (V1EndpointAddress)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

