/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="CustomResourceSubresourceScale defines how to serve the scale subresource for CustomResources.")
public class V1CustomResourceSubresourceScale {
    public static final String SERIALIZED_NAME_LABEL_SELECTOR_PATH = "labelSelectorPath";
    @SerializedName(value="labelSelectorPath")
    @Nullable
    private String labelSelectorPath;
    public static final String SERIALIZED_NAME_SPEC_REPLICAS_PATH = "specReplicasPath";
    @SerializedName(value="specReplicasPath")
    @Nonnull
    private String specReplicasPath;
    public static final String SERIALIZED_NAME_STATUS_REPLICAS_PATH = "statusReplicasPath";
    @SerializedName(value="statusReplicasPath")
    @Nonnull
    private String statusReplicasPath;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1CustomResourceSubresourceScale labelSelectorPath(@Nullable String labelSelectorPath) {
        this.labelSelectorPath = labelSelectorPath;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="labelSelectorPath defines the JSON path inside of a custom resource that corresponds to Scale `status.selector`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.status` or `.spec`. Must be set to work with HorizontalPodAutoscaler. The field pointed by this JSON path must be a string field (not a complex selector struct) which contains a serialized label selector in string form. More info: https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions#scale-subresource If there is no value under the given path in the custom resource, the `status.selector` value in the `/scale` subresource will default to the empty string.")
    public String getLabelSelectorPath() {
        return this.labelSelectorPath;
    }

    public void setLabelSelectorPath(@Nullable String labelSelectorPath) {
        this.labelSelectorPath = labelSelectorPath;
    }

    public V1CustomResourceSubresourceScale specReplicasPath(@Nonnull String specReplicasPath) {
        this.specReplicasPath = specReplicasPath;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="specReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale `spec.replicas`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.spec`. If there is no value under the given path in the custom resource, the `/scale` subresource will return an error on GET.")
    public String getSpecReplicasPath() {
        return this.specReplicasPath;
    }

    public void setSpecReplicasPath(@Nonnull String specReplicasPath) {
        this.specReplicasPath = specReplicasPath;
    }

    public V1CustomResourceSubresourceScale statusReplicasPath(@Nonnull String statusReplicasPath) {
        this.statusReplicasPath = statusReplicasPath;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="statusReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale `status.replicas`. Only JSON paths without the array notation are allowed. Must be a JSON Path under `.status`. If there is no value under the given path in the custom resource, the `status.replicas` value in the `/scale` subresource will default to 0.")
    public String getStatusReplicasPath() {
        return this.statusReplicasPath;
    }

    public void setStatusReplicasPath(@Nonnull String statusReplicasPath) {
        this.statusReplicasPath = statusReplicasPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CustomResourceSubresourceScale v1CustomResourceSubresourceScale = (V1CustomResourceSubresourceScale)o;
        return Objects.equals(this.labelSelectorPath, v1CustomResourceSubresourceScale.labelSelectorPath) && Objects.equals(this.specReplicasPath, v1CustomResourceSubresourceScale.specReplicasPath) && Objects.equals(this.statusReplicasPath, v1CustomResourceSubresourceScale.statusReplicasPath);
    }

    public int hashCode() {
        return Objects.hash(this.labelSelectorPath, this.specReplicasPath, this.statusReplicasPath);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1CustomResourceSubresourceScale {\n");
        sb.append("    labelSelectorPath: ").append(this.toIndentedString(this.labelSelectorPath)).append("\n");
        sb.append("    specReplicasPath: ").append(this.toIndentedString(this.specReplicasPath)).append("\n");
        sb.append("    statusReplicasPath: ").append(this.toIndentedString(this.statusReplicasPath)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1CustomResourceSubresourceScale is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1CustomResourceSubresourceScale` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_LABEL_SELECTOR_PATH) != null && !jsonObj.get(SERIALIZED_NAME_LABEL_SELECTOR_PATH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LABEL_SELECTOR_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `labelSelectorPath` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LABEL_SELECTOR_PATH).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_SPEC_REPLICAS_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `specReplicasPath` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SPEC_REPLICAS_PATH).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_STATUS_REPLICAS_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `statusReplicasPath` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS_REPLICAS_PATH).toString()));
        }
    }

    public static V1CustomResourceSubresourceScale fromJson(String jsonString) throws IOException {
        return (V1CustomResourceSubresourceScale)JSON.getGson().fromJson(jsonString, V1CustomResourceSubresourceScale.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LABEL_SELECTOR_PATH);
        openapiFields.add(SERIALIZED_NAME_SPEC_REPLICAS_PATH);
        openapiFields.add(SERIALIZED_NAME_STATUS_REPLICAS_PATH);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_SPEC_REPLICAS_PATH);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS_REPLICAS_PATH);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1CustomResourceSubresourceScale.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1CustomResourceSubresourceScale.class));
            return new TypeAdapter<V1CustomResourceSubresourceScale>(){

                public void write(JsonWriter out, V1CustomResourceSubresourceScale value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1CustomResourceSubresourceScale read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1CustomResourceSubresourceScale.validateJsonElement(jsonElement);
                    return (V1CustomResourceSubresourceScale)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

