/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.stub;

import com.google.common.base.Preconditions;
import io.grpc.CallCredentials;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.Deadline;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public abstract class AbstractStub<S extends AbstractStub<S>> {
    private final Channel channel;
    private final CallOptions callOptions;

    protected AbstractStub(Channel channel) {
        this(channel, CallOptions.DEFAULT);
    }

    protected AbstractStub(Channel channel, CallOptions callOptions) {
        this.channel = (Channel)Preconditions.checkNotNull((Object)channel, (Object)"channel");
        this.callOptions = (CallOptions)Preconditions.checkNotNull((Object)callOptions, (Object)"callOptions");
    }

    public final Channel getChannel() {
        return this.channel;
    }

    public final CallOptions getCallOptions() {
        return this.callOptions;
    }

    protected abstract S build(Channel var1, CallOptions var2);

    public final S withDeadline(@Nullable Deadline deadline) {
        return this.build(this.channel, this.callOptions.withDeadline(deadline));
    }

    public final S withDeadlineAfter(long duration, TimeUnit unit) {
        return this.build(this.channel, this.callOptions.withDeadlineAfter(duration, unit));
    }

    public final S withCompression(String compressorName) {
        return this.build(this.channel, this.callOptions.withCompression(compressorName));
    }

    public final S withChannel(Channel newChannel) {
        return this.build(newChannel, this.callOptions);
    }

    public final <T> S withOption(CallOptions.Key<T> key, T value) {
        return this.build(this.channel, this.callOptions.withOption(key, value));
    }

    public final S withInterceptors(ClientInterceptor ... interceptors) {
        return this.build(ClientInterceptors.intercept((Channel)this.channel, (ClientInterceptor[])interceptors), this.callOptions);
    }

    public final S withCallCredentials(CallCredentials credentials) {
        return this.build(this.channel, this.callOptions.withCallCredentials(credentials));
    }

    public final S withWaitForReady() {
        return this.build(this.channel, this.callOptions.withWaitForReady());
    }

    public final S withMaxInboundMessageSize(int maxSize) {
        return this.build(this.channel, this.callOptions.withMaxInboundMessageSize(maxSize));
    }

    public final S withMaxOutboundMessageSize(int maxSize) {
        return this.build(this.channel, this.callOptions.withMaxOutboundMessageSize(maxSize));
    }
}

