/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.grpc.internal.AbstractReadableBuffer;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

class NettyReadableBuffer
extends AbstractReadableBuffer {
    private final ByteBuf buffer;
    private boolean closed;

    NettyReadableBuffer(ByteBuf buffer) {
        this.buffer = (ByteBuf)Preconditions.checkNotNull((Object)buffer, (Object)"buffer");
    }

    ByteBuf buffer() {
        return this.buffer;
    }

    public int readableBytes() {
        return this.buffer.readableBytes();
    }

    public void skipBytes(int length) {
        this.buffer.skipBytes(length);
    }

    public int readUnsignedByte() {
        return this.buffer.readUnsignedByte();
    }

    public void readBytes(byte[] dest, int index, int length) {
        this.buffer.readBytes(dest, index, length);
    }

    public void readBytes(ByteBuffer dest) {
        this.buffer.readBytes(dest);
    }

    public void readBytes(OutputStream dest, int length) {
        try {
            this.buffer.readBytes(dest, length);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public NettyReadableBuffer readBytes(int length) {
        return new NettyReadableBuffer(this.buffer.readSlice(length).retain());
    }

    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    public byte[] array() {
        return this.buffer.array();
    }

    public int arrayOffset() {
        return this.buffer.arrayOffset() + this.buffer.readerIndex();
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.buffer.release();
        }
    }
}

