/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Preconditions;
import io.grpc.Status;
import io.grpc.internal.GrpcUtil;
import io.grpc.netty.NettyClientStream;

class CancelClientStreamCommand {
    private final NettyClientStream stream;
    private final Status reason;

    CancelClientStreamCommand(NettyClientStream stream, Status reason) {
        this.stream = (NettyClientStream)((Object)Preconditions.checkNotNull((Object)((Object)stream), (Object)"stream"));
        Preconditions.checkNotNull((Object)reason);
        Preconditions.checkArgument((boolean)GrpcUtil.CANCEL_REASONS.contains(reason.getCode()), (Object)"Invalid cancellation reason");
        this.reason = reason;
    }

    NettyClientStream stream() {
        return this.stream;
    }

    Status reason() {
        return this.reason;
    }
}

