/*
 * Decompiled with CFR 0.152.
 */
package io.github.zlika.reproducible;

import io.github.zlika.reproducible.DefaultZipStripper;
import io.github.zlika.reproducible.FileUtils;
import io.github.zlika.reproducible.LineEndingsStripper;
import io.github.zlika.reproducible.PatternFileNameFilter;
import io.github.zlika.reproducible.SmartTarStripper;
import io.github.zlika.reproducible.SpringBootExecutableStripper;
import io.github.zlika.reproducible.Stripper;
import io.github.zlika.reproducible.ZipStripper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="strip-jar", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, requiresProject=false, threadSafe=true)
public final class StripJarMojo
extends AbstractMojo {
    private static final List<String> ZIP_EXT = Arrays.asList("zip", "jar", "war", "ear", "hpi", "adapter");
    private static final List<String> TAR_GZ_EXT = Collections.singletonList("tar.gz");
    private static final List<String> TAR_BZ_EXT = Collections.singletonList("tar.bz2");
    private static final List<String> TAR_EXT = Collections.singletonList("tar");
    private static final byte[] ZIP_FILE_HEADER = new byte[]{80, 75, 3, 4};
    private static final byte[] SPRING_BOOT_EXEC_HEADER = new byte[]{35, 33, 47, 98, 105, 110};
    @Parameter(defaultValue="${project.build.directory}", property="reproducible.outputDirectory", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="true", property="reproducible.overwrite")
    private boolean overwrite;
    @Parameter(defaultValue="false", property="reproducible.skip")
    private boolean skip;
    @Parameter(defaultValue="20000101000000", property="reproducible.zipDateTime")
    private String zipDateTime;
    @Parameter(defaultValue="yyyyMMddHHmmss", property="reproducible.zipDateTimeFormatPattern")
    private String zipDateTimeFormatPattern;
    @Parameter(defaultValue="false", property="reproducible.fixZipExternalFileAttributes")
    private boolean fixZipExternalFileAttributes;
    @Parameter(property="reproducible.manifestAttributes")
    private List<String> manifestAttributes;
    @Parameter(property="reproducible.newLineTextFiles")
    private List<String> newLineTextFiles;
    @Parameter(property="reproducible.includes")
    private List<String> includes;
    @Parameter(property="reproducible.excludes")
    private List<String> excludes;
    @Parameter(property="reproducible.nestedIncludes")
    private List<String> nestedIncludes;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution of goal \"strip-jar\"");
        } else {
            if (this.includes == null || this.includes.isEmpty()) {
                this.includes = Collections.singletonList(".*");
            }
            if (this.excludes == null) {
                this.excludes = Collections.emptyList();
            }
            LocalDateTime reproducibleDateTime = LocalDateTime.parse(this.zipDateTime, DateTimeFormatter.ofPattern(this.zipDateTimeFormatPattern));
            ZipStripper zipStripper = new ZipStripper(reproducibleDateTime, this.fixZipExternalFileAttributes);
            this.newLineTextFiles.forEach(f -> zipStripper.addFileStripper((String)f, LineEndingsStripper.INSTANCE));
            DefaultZipStripper stripper = new DefaultZipStripper(zipStripper, this.overwrite, this.manifestAttributes);
            if (this.nestedIncludes != null && !this.nestedIncludes.isEmpty()) {
                DefaultZipStripper nestedFileStripper = new DefaultZipStripper(zipStripper, false, this.manifestAttributes);
                for (String include : this.nestedIncludes) {
                    if (!include.endsWith("jar") && !include.endsWith("zip")) continue;
                    zipStripper.addFileStripper(include, nestedFileStripper);
                }
            }
            this.process(this.findZipFiles(this.outputDirectory), stripper);
            this.process(this.findSpringBootExecutable(this.outputDirectory), new SpringBootExecutableStripper(this.overwrite, new DefaultZipStripper(zipStripper, false, this.manifestAttributes)));
            this.process(this.findTarFiles(this.outputDirectory), new SmartTarStripper(this.overwrite, reproducibleDateTime));
            this.process(this.findTarBzFiles(this.outputDirectory), new SmartTarStripper(this.overwrite, reproducibleDateTime));
            this.process(this.findTarGzFiles(this.outputDirectory), new SmartTarStripper(this.overwrite, reproducibleDateTime));
        }
    }

    private void process(File[] files, Stripper stripper) throws MojoExecutionException {
        for (File file : files) {
            this.getLog().info((CharSequence)("Stripping " + file.getAbsolutePath()));
            try {
                stripper.strip(file, this.createStrippedFilename(file));
            }
            catch (IOException ioe) {
                throw new MojoExecutionException(String.format("Error stripping file %s:", file.getAbsolutePath()), (Exception)ioe);
            }
        }
    }

    private File[] findZipFiles(File folder) {
        PatternFileNameFilter filter = PatternFileNameFilter.of(this.getLog(), this.includes, this.excludes, ZIP_EXT);
        File[] zipFiles = folder.listFiles((dir, name) -> filter.accept(dir, name) && new File(dir, name).isFile() && Arrays.equals(this.getFileHeader(new File(dir, name), ZIP_FILE_HEADER.length), ZIP_FILE_HEADER));
        return zipFiles != null ? zipFiles : new File[]{};
    }

    private File[] findSpringBootExecutable(File folder) {
        PatternFileNameFilter filter = PatternFileNameFilter.of(this.getLog(), this.includes, this.excludes, ZIP_EXT);
        File[] zipFiles = folder.listFiles((dir, name) -> filter.accept(dir, name) && new File(dir, name).isFile() && Arrays.equals(this.getFileHeader(new File(dir, name), SPRING_BOOT_EXEC_HEADER.length), SPRING_BOOT_EXEC_HEADER));
        return zipFiles != null ? zipFiles : new File[]{};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getFileHeader(File file, int length) {
        byte[] header = new byte[length];
        try (FileInputStream is = new FileInputStream(file);){
            if (is.read(header) == length) return header;
            byte[] byArray = null;
            return byArray;
        }
        catch (IOException e) {
            return null;
        }
    }

    private File[] findTarBzFiles(File folder) {
        PatternFileNameFilter filter = PatternFileNameFilter.of(this.getLog(), this.includes, this.excludes, TAR_BZ_EXT);
        File[] tbzFiles = folder.listFiles(filter);
        return tbzFiles != null ? tbzFiles : new File[]{};
    }

    private File[] findTarGzFiles(File folder) {
        PatternFileNameFilter filter = PatternFileNameFilter.of(this.getLog(), this.includes, this.excludes, TAR_GZ_EXT);
        File[] tgzFiles = folder.listFiles(filter);
        return tgzFiles != null ? tgzFiles : new File[]{};
    }

    private File[] findTarFiles(File folder) {
        PatternFileNameFilter filter = PatternFileNameFilter.of(this.getLog(), this.includes, this.excludes, TAR_EXT);
        File[] tarFiles = folder.listFiles(filter);
        return tarFiles != null ? tarFiles : new File[]{};
    }

    private File createStrippedFilename(File originalFile) {
        String filenameWithoutExt = FileUtils.getNameWithoutExtension(originalFile);
        String ext = FileUtils.getFileExtension(originalFile);
        return new File(originalFile.getParentFile(), filenameWithoutExt + "-stripped" + (ext.isEmpty() ? "" : ".") + ext);
    }
}

