/*
 * Decompiled with CFR 0.152.
 */
package io.github.zlika.reproducible;

import io.github.zlika.reproducible.Stripper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

final class SortManifestFileStripper
implements Stripper {
    private static final Comparator<String> MANIFEST_ENTRY_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if (o1.startsWith("Manifest-Version:")) {
                return -1;
            }
            if (o2.startsWith("Manifest-Version:")) {
                return 1;
            }
            if (o1.startsWith("Name:") && !o2.startsWith("Name:")) {
                return -1;
            }
            if (o2.startsWith("Name:") && !o1.startsWith("Name:")) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    };

    SortManifestFileStripper() {
    }

    @Override
    public void strip(File in, File out) throws IOException {
        List<String> lines = Files.readAllLines(in.toPath(), StandardCharsets.UTF_8);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(out), StandardCharsets.UTF_8));){
            String sortedManifest = this.sortManifestSections(lines).stream().collect(Collectors.joining("\r\n"));
            try {
                writer.write(sortedManifest + "\r\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private List<String> sortManifestSections(List<String> lines) {
        ArrayList sections = new ArrayList();
        ArrayList<String> currentSection = new ArrayList<String>();
        for (String line : lines) {
            if (line.isEmpty()) {
                if (currentSection.isEmpty()) continue;
                sections.add(currentSection);
                currentSection = new ArrayList();
                continue;
            }
            currentSection.add(line);
        }
        if (!currentSection.isEmpty()) {
            sections.add(currentSection);
        }
        return sections.stream().map(list -> this.sortAttributes((List<String>)list)).map(list -> String.join((CharSequence)"", list)).sorted(MANIFEST_ENTRY_COMPARATOR).collect(Collectors.toList());
    }

    private List<String> sortAttributes(List<String> lines) {
        ArrayList<String> attributes = new ArrayList<String>();
        String currentAttribute = "";
        for (String line : lines) {
            if (line.startsWith(" ")) {
                currentAttribute = currentAttribute + line + "\r\n";
                continue;
            }
            if (!currentAttribute.isEmpty()) {
                attributes.add(currentAttribute);
                currentAttribute = "";
            }
            currentAttribute = line + "\r\n";
        }
        if (!currentAttribute.isEmpty()) {
            attributes.add(currentAttribute);
        }
        attributes.sort(MANIFEST_ENTRY_COMPARATOR);
        return attributes;
    }
}

