/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.busyexpr;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringJoiner;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.dataflow.analysis.Store;
import org.checkerframework.errorprone.dataflow.busyexpr.BusyExprValue;
import org.checkerframework.errorprone.dataflow.cfg.node.BinaryOperationNode;
import org.checkerframework.errorprone.dataflow.cfg.node.Node;
import org.checkerframework.errorprone.dataflow.cfg.visualize.CFGVisualizer;
import org.checkerframework.errorprone.dataflow.expression.JavaExpression;
import org.checkerframework.errorprone.javacutil.BugInCF;

public class BusyExprStore
implements Store<BusyExprStore> {
    private final Set<BusyExprValue> busyExprValueSet;

    public BusyExprStore(Set<BusyExprValue> busyExprValueSet) {
        this.busyExprValueSet = busyExprValueSet;
    }

    public BusyExprStore() {
        this.busyExprValueSet = new LinkedHashSet<BusyExprValue>();
    }

    public void killBusyExpr(Node var) {
        this.busyExprValueSet.removeIf(busyExprValue -> this.exprContainsVariable(busyExprValue.busyExpression, var));
    }

    public boolean exprContainsVariable(Node expr, Node var) {
        if (expr instanceof BinaryOperationNode) {
            BinaryOperationNode binaryNode = (BinaryOperationNode)expr;
            return this.exprContainsVariable(binaryNode.getLeftOperand(), var) || this.exprContainsVariable(binaryNode.getRightOperand(), var);
        }
        return expr.equals(var);
    }

    public void putBusyExpr(BusyExprValue e) {
        this.busyExprValueSet.add(e);
    }

    public void addUseInExpression(Node e) {
        if (e instanceof BinaryOperationNode) {
            BinaryOperationNode binaryNode = (BinaryOperationNode)e;
            this.putBusyExpr(new BusyExprValue(binaryNode));
            this.addUseInExpression(binaryNode.getLeftOperand());
            this.addUseInExpression(binaryNode.getRightOperand());
        }
    }

    @Override
    public BusyExprStore copy() {
        return new BusyExprStore(new LinkedHashSet<BusyExprValue>(this.busyExprValueSet));
    }

    @Override
    public BusyExprStore leastUpperBound(BusyExprStore other) {
        LinkedHashSet<BusyExprValue> busyExprValueSetLub = new LinkedHashSet<BusyExprValue>(this.busyExprValueSet);
        busyExprValueSetLub.retainAll(other.busyExprValueSet);
        return new BusyExprStore(busyExprValueSetLub);
    }

    @Override
    public BusyExprStore widenedUpperBound(BusyExprStore previous) {
        throw new BugInCF("BusyExprStore.widenedUpperBound was called!");
    }

    @Override
    public boolean canAlias(JavaExpression a, JavaExpression b) {
        return true;
    }

    @Override
    public String visualize(CFGVisualizer<?, BusyExprStore, ?> viz) {
        String key = "busy expressions";
        if (this.busyExprValueSet.isEmpty()) {
            return viz.visualizeStoreKeyVal(key, "none");
        }
        StringJoiner sjStoreVal = new StringJoiner(", ");
        for (BusyExprValue busyExprValue : this.busyExprValueSet) {
            sjStoreVal.add(busyExprValue.toString());
        }
        return viz.visualizeStoreKeyVal(key, sjStoreVal.toString());
    }

    public String toString() {
        return this.busyExprValueSet.toString();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof BusyExprStore)) {
            return false;
        }
        BusyExprStore other = (BusyExprStore)obj;
        return other.busyExprValueSet.equals(this.busyExprValueSet);
    }

    public int hashCode() {
        return this.busyExprValueSet.hashCode();
    }
}

