/*
 * Decompiled with CFR 0.152.
 */
package io.github.artsok.internal;

import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;

class RepeatExecutionCondition
implements ExecutionCondition {
    private final int totalTestRuns;
    private final int minSuccess;
    private final int successfulTestRepetitionsCount;
    private final int failedTestRepetitionsCount;
    private final boolean repeatableExceptionAppeared;

    RepeatExecutionCondition(int currentRepetition, int totalRepetitions, int minSuccess, int successfulTestRepetitionsCount, boolean repeatableExceptionAppeared) {
        this.totalTestRuns = totalRepetitions;
        this.minSuccess = minSuccess;
        this.successfulTestRepetitionsCount = successfulTestRepetitionsCount;
        this.failedTestRepetitionsCount = currentRepetition - successfulTestRepetitionsCount - 1;
        this.repeatableExceptionAppeared = repeatableExceptionAppeared;
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        if (this.testUltimatelyFailed()) {
            return ConditionEvaluationResult.disabled((String)"Turn off the remaining repetitions as the test ultimately failed");
        }
        if (this.testUltimatelyPassed()) {
            return ConditionEvaluationResult.disabled((String)"Turn off the remaining repetitions as the test ultimately passed");
        }
        return ConditionEvaluationResult.enabled((String)"Repeat the tests");
    }

    private boolean testUltimatelyFailed() {
        return this.aNonRepeatableExceptionAppeared() || this.minimalRequiredSuccessfulRunsCannotBeReachedAnymore();
    }

    private boolean aNonRepeatableExceptionAppeared() {
        return this.failedTestRepetitionsCount > 0 && !this.repeatableExceptionAppeared;
    }

    private boolean minimalRequiredSuccessfulRunsCannotBeReachedAnymore() {
        return this.totalTestRuns - this.failedTestRepetitionsCount < this.minSuccess;
    }

    private boolean testUltimatelyPassed() {
        return this.successfulTestRepetitionsCount >= this.minSuccess;
    }
}

