/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.commonscompress.archivers.zip;

import java.io.Closeable;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public abstract class StreamCompressor
implements Closeable {
    private final Deflater def;
    private final CRC32 crc;
    private long writtenToOutputStreamForLastEntry;
    private long sourcePayloadLength;
    private long totalWrittenToOutputStream;
    private final byte[] outputBuffer;

    public long getTotalBytesWritten() {
        return this.totalWrittenToOutputStream;
    }

    long write(byte[] b, int offset, int length, int method) throws IOException {
        long current = this.writtenToOutputStreamForLastEntry;
        this.crc.update(b, offset, length);
        if (method == 8) {
            this.writeDeflated(b, offset, length);
        } else {
            this.writeCounted(b, offset, length);
        }
        this.sourcePayloadLength += (long)length;
        return this.writtenToOutputStreamForLastEntry - current;
    }

    @Override
    public void close() throws IOException {
        this.def.end();
    }

    private void writeDeflated(byte[] b, int offset, int length) throws IOException {
        if (length > 0 && !this.def.finished()) {
            if (length <= 8192) {
                this.def.setInput(b, offset, length);
                this.deflateUntilInputIsNeeded();
            } else {
                int fullblocks = length / 8192;
                for (int i = 0; i < fullblocks; ++i) {
                    this.def.setInput(b, offset + i * 8192, 8192);
                    this.deflateUntilInputIsNeeded();
                }
                int done = fullblocks * 8192;
                if (done < length) {
                    this.def.setInput(b, offset + done, length - done);
                    this.deflateUntilInputIsNeeded();
                }
            }
        }
    }

    private void deflateUntilInputIsNeeded() throws IOException {
        while (!this.def.needsInput()) {
            this.deflate();
        }
    }

    void deflate() throws IOException {
        int len = this.def.deflate(this.outputBuffer, 0, this.outputBuffer.length);
        if (len > 0) {
            this.writeCounted(this.outputBuffer, 0, len);
        }
    }

    public void writeCounted(byte[] data) throws IOException {
        this.writeCounted(data, 0, data.length);
    }

    public void writeCounted(byte[] data, int offset, int length) throws IOException {
        this.writeOut(data, offset, length);
        this.writtenToOutputStreamForLastEntry += (long)length;
        this.totalWrittenToOutputStream += (long)length;
    }

    protected abstract void writeOut(byte[] var1, int var2, int var3) throws IOException;
}

