/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.scala.collection.mutable;

import coursierapi.shaded.scala.Array$;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.collection.IterableOnce;
import coursierapi.shaded.scala.collection.mutable.Builder;
import coursierapi.shaded.scala.collection.mutable.Growable;
import coursierapi.shaded.scala.collection.mutable.Iterable;
import coursierapi.shaded.scala.collection.mutable.ReusableBuilder;
import coursierapi.shaded.scala.reflect.ClassTag;
import coursierapi.shaded.scala.runtime.BoxedUnit;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;

public abstract class ArrayBuilder<T>
implements Serializable,
ReusableBuilder<T, Object> {
    private int capacity = 0;
    private int size = 0;

    @Override
    public final void sizeHintBounded(int size, coursierapi.shaded.scala.collection.Iterable<?> boundingColl) {
        Builder.sizeHintBounded$(this, size, boundingColl);
    }

    @Override
    public <NewTo> Builder<T, NewTo> mapResult(Function1<Object, NewTo> f) {
        return Builder.mapResult$(this, f);
    }

    @Override
    public final Growable<T> $plus$eq(T elem) {
        return Growable.$plus$eq$(this, elem);
    }

    @Override
    public final Growable<T> $plus$plus$eq(IterableOnce<T> xs) {
        return Growable.$plus$plus$eq$(this, xs);
    }

    public int capacity() {
        return this.capacity;
    }

    public void capacity_$eq(int x$1) {
        this.capacity = x$1;
    }

    public abstract Object elems();

    public int size() {
        return this.size;
    }

    public void size_$eq(int x$1) {
        this.size = x$1;
    }

    public final void ensureSize(int size) {
        if (this.capacity() < size || this.capacity() == 0) {
            int newsize;
            int n = newsize = this.capacity() == 0 ? 16 : this.capacity() * 2;
            while (newsize < size) {
                newsize *= 2;
            }
            this.resize(newsize);
        }
    }

    @Override
    public final void sizeHint(int size) {
        if (this.capacity() < size) {
            this.resize(size);
        }
    }

    @Override
    public void clear() {
        this.size_$eq(0);
    }

    public abstract void resize(int var1);

    public ArrayBuilder<T> addAll(Object xs) {
        return this.addAll(xs, 0, Array.getLength(xs));
    }

    public ArrayBuilder<T> addAll(Object xs, int offset, int length) {
        this.ensureSize(this.size() + length);
        Array$.MODULE$.copy(xs, offset, this.elems(), this.size(), length);
        this.size_$eq(this.size() + length);
        return this;
    }

    @Override
    public ArrayBuilder<T> addAll(IterableOnce<T> xs) {
        int k = xs.knownSize();
        if (k > 0) {
            this.ensureSize(this.size() + k);
            if (xs instanceof Iterable) {
                ((Iterable)xs).copyToArray(this.elems(), this.size());
            } else {
                xs.iterator().copyToArray(this.elems(), this.size());
            }
            this.size_$eq(this.size() + k);
        } else if (k < 0) {
            Growable.addAll$(this, xs);
        }
        return this;
    }

    public static class ofBoolean
    extends ArrayBuilder<Object> {
        private boolean[] elems;

        public boolean[] elems() {
            return this.elems;
        }

        public void elems_$eq(boolean[] x$1) {
            this.elems = x$1;
        }

        /*
         * WARNING - void declaration
         */
        private boolean[] mkArray(int size) {
            void var2_2;
            boolean[] newelems = new boolean[size];
            if (this.size() > 0) {
                Array$.MODULE$.copy(this.elems(), 0, newelems, 0, this.size());
            }
            return var2_2;
        }

        @Override
        public void resize(int size) {
            this.elems_$eq(this.mkArray(size));
            this.capacity_$eq(size);
        }

        public ofBoolean addOne(boolean elem) {
            this.ensureSize(this.size() + 1);
            this.elems()[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean[] result() {
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var1_1;
                this.capacity_$eq(0);
                boolean[] res = this.elems();
                this.elems_$eq(null);
                return var1_1;
            }
            return this.mkArray(this.size());
        }

        public boolean equals(Object other) {
            boolean bl;
            if (other instanceof ofBoolean) {
                ofBoolean ofBoolean2 = (ofBoolean)other;
                bl = this.size() == ofBoolean2.size() && this.elems() == ofBoolean2.elems();
            } else {
                bl = false;
            }
            return bl;
        }

        public String toString() {
            return "ArrayBuilder.ofBoolean";
        }
    }

    public static final class ofByte
    extends ArrayBuilder<Object> {
        private byte[] elems;

        public byte[] elems() {
            return this.elems;
        }

        public void elems_$eq(byte[] x$1) {
            this.elems = x$1;
        }

        /*
         * WARNING - void declaration
         */
        private byte[] mkArray(int size) {
            void var2_2;
            byte[] newelems = new byte[size];
            if (this.size() > 0) {
                Array$.MODULE$.copy(this.elems(), 0, newelems, 0, this.size());
            }
            return var2_2;
        }

        @Override
        public void resize(int size) {
            this.elems_$eq(this.mkArray(size));
            this.capacity_$eq(size);
        }

        public ofByte addOne(byte elem) {
            this.ensureSize(this.size() + 1);
            this.elems()[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public byte[] result() {
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var1_1;
                this.capacity_$eq(0);
                byte[] res = this.elems();
                this.elems_$eq(null);
                return var1_1;
            }
            return this.mkArray(this.size());
        }

        public boolean equals(Object other) {
            boolean bl;
            if (other instanceof ofByte) {
                ofByte ofByte2 = (ofByte)other;
                bl = this.size() == ofByte2.size() && this.elems() == ofByte2.elems();
            } else {
                bl = false;
            }
            return bl;
        }

        public String toString() {
            return "ArrayBuilder.ofByte";
        }
    }

    public static final class ofChar
    extends ArrayBuilder<Object> {
        private char[] elems;

        public char[] elems() {
            return this.elems;
        }

        public void elems_$eq(char[] x$1) {
            this.elems = x$1;
        }

        /*
         * WARNING - void declaration
         */
        private char[] mkArray(int size) {
            void var2_2;
            char[] newelems = new char[size];
            if (this.size() > 0) {
                Array$.MODULE$.copy(this.elems(), 0, newelems, 0, this.size());
            }
            return var2_2;
        }

        @Override
        public void resize(int size) {
            this.elems_$eq(this.mkArray(size));
            this.capacity_$eq(size);
        }

        public ofChar addOne(char elem) {
            this.ensureSize(this.size() + 1);
            this.elems()[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public char[] result() {
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var1_1;
                this.capacity_$eq(0);
                char[] res = this.elems();
                this.elems_$eq(null);
                return var1_1;
            }
            return this.mkArray(this.size());
        }

        public boolean equals(Object other) {
            boolean bl;
            if (other instanceof ofChar) {
                ofChar ofChar2 = (ofChar)other;
                bl = this.size() == ofChar2.size() && this.elems() == ofChar2.elems();
            } else {
                bl = false;
            }
            return bl;
        }

        public String toString() {
            return "ArrayBuilder.ofChar";
        }
    }

    public static final class ofDouble
    extends ArrayBuilder<Object> {
        private double[] elems;

        public double[] elems() {
            return this.elems;
        }

        public void elems_$eq(double[] x$1) {
            this.elems = x$1;
        }

        /*
         * WARNING - void declaration
         */
        private double[] mkArray(int size) {
            void var2_2;
            double[] newelems = new double[size];
            if (this.size() > 0) {
                Array$.MODULE$.copy(this.elems(), 0, newelems, 0, this.size());
            }
            return var2_2;
        }

        @Override
        public void resize(int size) {
            this.elems_$eq(this.mkArray(size));
            this.capacity_$eq(size);
        }

        public ofDouble addOne(double elem) {
            this.ensureSize(this.size() + 1);
            this.elems()[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public double[] result() {
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var1_1;
                this.capacity_$eq(0);
                double[] res = this.elems();
                this.elems_$eq(null);
                return var1_1;
            }
            return this.mkArray(this.size());
        }

        public boolean equals(Object other) {
            boolean bl;
            if (other instanceof ofDouble) {
                ofDouble ofDouble2 = (ofDouble)other;
                bl = this.size() == ofDouble2.size() && this.elems() == ofDouble2.elems();
            } else {
                bl = false;
            }
            return bl;
        }

        public String toString() {
            return "ArrayBuilder.ofDouble";
        }
    }

    public static final class ofFloat
    extends ArrayBuilder<Object> {
        private float[] elems;

        public float[] elems() {
            return this.elems;
        }

        public void elems_$eq(float[] x$1) {
            this.elems = x$1;
        }

        /*
         * WARNING - void declaration
         */
        private float[] mkArray(int size) {
            void var2_2;
            float[] newelems = new float[size];
            if (this.size() > 0) {
                Array$.MODULE$.copy(this.elems(), 0, newelems, 0, this.size());
            }
            return var2_2;
        }

        @Override
        public void resize(int size) {
            this.elems_$eq(this.mkArray(size));
            this.capacity_$eq(size);
        }

        public ofFloat addOne(float elem) {
            this.ensureSize(this.size() + 1);
            this.elems()[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public float[] result() {
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var1_1;
                this.capacity_$eq(0);
                float[] res = this.elems();
                this.elems_$eq(null);
                return var1_1;
            }
            return this.mkArray(this.size());
        }

        public boolean equals(Object other) {
            boolean bl;
            if (other instanceof ofFloat) {
                ofFloat ofFloat2 = (ofFloat)other;
                bl = this.size() == ofFloat2.size() && this.elems() == ofFloat2.elems();
            } else {
                bl = false;
            }
            return bl;
        }

        public String toString() {
            return "ArrayBuilder.ofFloat";
        }
    }

    public static final class ofInt
    extends ArrayBuilder<Object> {
        private int[] elems;

        public int[] elems() {
            return this.elems;
        }

        public void elems_$eq(int[] x$1) {
            this.elems = x$1;
        }

        /*
         * WARNING - void declaration
         */
        private int[] mkArray(int size) {
            void var2_2;
            int[] newelems = new int[size];
            if (this.size() > 0) {
                Array$.MODULE$.copy(this.elems(), 0, newelems, 0, this.size());
            }
            return var2_2;
        }

        @Override
        public void resize(int size) {
            this.elems_$eq(this.mkArray(size));
            this.capacity_$eq(size);
        }

        public ofInt addOne(int elem) {
            this.ensureSize(this.size() + 1);
            this.elems()[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int[] result() {
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var1_1;
                this.capacity_$eq(0);
                int[] res = this.elems();
                this.elems_$eq(null);
                return var1_1;
            }
            return this.mkArray(this.size());
        }

        public boolean equals(Object other) {
            boolean bl;
            if (other instanceof ofInt) {
                ofInt ofInt2 = (ofInt)other;
                bl = this.size() == ofInt2.size() && this.elems() == ofInt2.elems();
            } else {
                bl = false;
            }
            return bl;
        }

        public String toString() {
            return "ArrayBuilder.ofInt";
        }
    }

    public static final class ofLong
    extends ArrayBuilder<Object> {
        private long[] elems;

        public long[] elems() {
            return this.elems;
        }

        public void elems_$eq(long[] x$1) {
            this.elems = x$1;
        }

        /*
         * WARNING - void declaration
         */
        private long[] mkArray(int size) {
            void var2_2;
            long[] newelems = new long[size];
            if (this.size() > 0) {
                Array$.MODULE$.copy(this.elems(), 0, newelems, 0, this.size());
            }
            return var2_2;
        }

        @Override
        public void resize(int size) {
            this.elems_$eq(this.mkArray(size));
            this.capacity_$eq(size);
        }

        public ofLong addOne(long elem) {
            this.ensureSize(this.size() + 1);
            this.elems()[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long[] result() {
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var1_1;
                this.capacity_$eq(0);
                long[] res = this.elems();
                this.elems_$eq(null);
                return var1_1;
            }
            return this.mkArray(this.size());
        }

        public boolean equals(Object other) {
            boolean bl;
            if (other instanceof ofLong) {
                ofLong ofLong2 = (ofLong)other;
                bl = this.size() == ofLong2.size() && this.elems() == ofLong2.elems();
            } else {
                bl = false;
            }
            return bl;
        }

        public String toString() {
            return "ArrayBuilder.ofLong";
        }
    }

    public static final class ofRef<T>
    extends ArrayBuilder<T> {
        private final ClassTag<T> ct;
        private T[] elems;

        public T[] elems() {
            return this.elems;
        }

        public void elems_$eq(T[] x$1) {
            this.elems = x$1;
        }

        private T[] mkArray(int size) {
            if (this.capacity() == size && this.capacity() > 0) {
                return this.elems();
            }
            if (this.elems() == null) {
                return (Object[])this.ct.newArray(size);
            }
            return Arrays.copyOf(this.elems(), size);
        }

        @Override
        public void resize(int size) {
            this.elems_$eq(this.mkArray(size));
            this.capacity_$eq(size);
        }

        @Override
        public ofRef<T> addOne(T elem) {
            this.ensureSize(this.size() + 1);
            this.elems()[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public T[] result() {
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var1_1;
                this.capacity_$eq(0);
                T[] res = this.elems();
                this.elems_$eq(null);
                return var1_1;
            }
            return this.mkArray(this.size());
        }

        @Override
        public void clear() {
            super.clear();
            if (this.elems() != null) {
                Arrays.fill(this.elems(), null);
            }
        }

        public boolean equals(Object other) {
            boolean bl;
            if (other instanceof ofRef) {
                ofRef ofRef2 = (ofRef)other;
                bl = this.size() == ofRef2.size() && this.elems() == ofRef2.elems();
            } else {
                bl = false;
            }
            return bl;
        }

        public String toString() {
            return "ArrayBuilder.ofRef";
        }

        public ofRef(ClassTag<T> ct) {
            this.ct = ct;
        }
    }

    public static final class ofShort
    extends ArrayBuilder<Object> {
        private short[] elems;

        public short[] elems() {
            return this.elems;
        }

        public void elems_$eq(short[] x$1) {
            this.elems = x$1;
        }

        /*
         * WARNING - void declaration
         */
        private short[] mkArray(int size) {
            void var2_2;
            short[] newelems = new short[size];
            if (this.size() > 0) {
                Array$.MODULE$.copy(this.elems(), 0, newelems, 0, this.size());
            }
            return var2_2;
        }

        @Override
        public void resize(int size) {
            this.elems_$eq(this.mkArray(size));
            this.capacity_$eq(size);
        }

        public ofShort addOne(short elem) {
            this.ensureSize(this.size() + 1);
            this.elems()[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public short[] result() {
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var1_1;
                this.capacity_$eq(0);
                short[] res = this.elems();
                this.elems_$eq(null);
                return var1_1;
            }
            return this.mkArray(this.size());
        }

        public boolean equals(Object other) {
            boolean bl;
            if (other instanceof ofShort) {
                ofShort ofShort2 = (ofShort)other;
                bl = this.size() == ofShort2.size() && this.elems() == ofShort2.elems();
            } else {
                bl = false;
            }
            return bl;
        }

        public String toString() {
            return "ArrayBuilder.ofShort";
        }
    }

    public static final class ofUnit
    extends ArrayBuilder<BoxedUnit> {
        public BoxedUnit[] elems() {
            throw new UnsupportedOperationException();
        }

        public ofUnit addOne(BoxedUnit elem) {
            this.size_$eq(this.size() + 1);
            return this;
        }

        public ofUnit addAll(IterableOnce<BoxedUnit> xs) {
            this.size_$eq(this.size() + xs.iterator().size());
            return this;
        }

        public ofUnit addAll(Object xs, int offset, int length) {
            this.size_$eq(this.size() + length);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public BoxedUnit[] result() {
            void var1_1;
            BoxedUnit[] ans = new BoxedUnit[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                ans[i] = BoxedUnit.UNIT;
            }
            return var1_1;
        }

        public boolean equals(Object other) {
            boolean bl;
            if (other instanceof ofUnit) {
                ofUnit ofUnit2 = (ofUnit)other;
                bl = this.size() == ofUnit2.size();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public void resize(int size) {
        }

        public String toString() {
            return "ArrayBuilder.ofUnit";
        }
    }
}

