/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.cache.shaded.org.jline.utils;

import coursierapi.shaded.coursier.cache.shaded.org.jline.terminal.Terminal;
import coursierapi.shaded.coursier.cache.shaded.org.jline.utils.AttributedString;
import coursierapi.shaded.coursier.cache.shaded.org.jline.utils.AttributedStyle;
import coursierapi.shaded.coursier.cache.shaded.org.jline.utils.Colors;
import coursierapi.shaded.coursier.cache.shaded.org.jline.utils.Curses;
import coursierapi.shaded.coursier.cache.shaded.org.jline.utils.InfoCmp;
import coursierapi.shaded.coursier.cache.shaded.org.jline.utils.WCWidth;

public abstract class AttributedCharSequence
implements CharSequence {
    static final boolean DISABLE_ALTERNATE_CHARSET = Boolean.getBoolean("coursierapi.shaded.coursier.cache.shaded.org.jline.utils.disableAlternateCharset");

    public void print(Terminal terminal) {
        terminal.writer().print(this.toAnsi(terminal));
    }

    public String toAnsi(Terminal terminal) {
        if (terminal != null && "dumb".equals(terminal.getType())) {
            return this.toString();
        }
        int colors = 256;
        boolean force256colors = false;
        String alternateIn = null;
        String alternateOut = null;
        if (terminal != null) {
            Integer max_colors = terminal.getNumericCapability(InfoCmp.Capability.max_colors);
            if (max_colors != null) {
                colors = max_colors;
            }
            boolean bl = force256colors = "windows-256color".equals(terminal.getType()) || "windows-conemu".equals(terminal.getType());
            if (!DISABLE_ALTERNATE_CHARSET) {
                alternateIn = Curses.tputs(terminal.getStringCapability(InfoCmp.Capability.enter_alt_charset_mode), new Object[0]);
                alternateOut = Curses.tputs(terminal.getStringCapability(InfoCmp.Capability.exit_alt_charset_mode), new Object[0]);
            }
        }
        return this.toAnsi(colors, force256colors, alternateIn, alternateOut);
    }

    public String toAnsi(int colors, boolean force256colors, String altIn, String altOut) {
        StringBuilder sb = new StringBuilder();
        int style = 0;
        int foreground = -1;
        int background = -1;
        boolean alt = false;
        for (int i = 0; i < this.length(); ++i) {
            int s;
            char c = this.charAt(i);
            if (altIn != null && altOut != null) {
                char pc = c;
                switch (c) {
                    case '\u2518': {
                        c = 'j';
                        break;
                    }
                    case '\u2510': {
                        c = 'k';
                        break;
                    }
                    case '\u250c': {
                        c = 'l';
                        break;
                    }
                    case '\u2514': {
                        c = 'm';
                        break;
                    }
                    case '\u253c': {
                        c = 'n';
                        break;
                    }
                    case '\u2500': {
                        c = 'q';
                        break;
                    }
                    case '\u251c': {
                        c = 't';
                        break;
                    }
                    case '\u2524': {
                        c = 'u';
                        break;
                    }
                    case '\u2534': {
                        c = 'v';
                        break;
                    }
                    case '\u252c': {
                        c = 'w';
                        break;
                    }
                    case '\u2502': {
                        c = 'x';
                    }
                }
                boolean oldalt = alt;
                boolean bl = alt = c != pc;
                if (oldalt ^ alt) {
                    sb.append(alt ? altIn : altOut);
                }
            }
            if (style != (s = this.styleCodeAt(i) & 0xFFFFFBFF)) {
                int bg;
                int d = (style ^ s) & 0x7FF;
                int fg = (s & 0x100) != 0 ? (s & 0xFF0000) >>> 16 : -1;
                int n = bg = (s & 0x200) != 0 ? (s & 0xFF000000) >>> 24 : -1;
                if (s == 0) {
                    sb.append("\u001b[0m");
                    background = -1;
                    foreground = -1;
                } else {
                    int rounded;
                    sb.append("\u001b[");
                    boolean first = true;
                    if ((d & 4) != 0) {
                        first = AttributedCharSequence.attr(sb, (s & 4) != 0 ? "3" : "23", first);
                    }
                    if ((d & 8) != 0) {
                        first = AttributedCharSequence.attr(sb, (s & 8) != 0 ? "4" : "24", first);
                    }
                    if ((d & 0x10) != 0) {
                        first = AttributedCharSequence.attr(sb, (s & 0x10) != 0 ? "5" : "25", first);
                    }
                    if ((d & 0x20) != 0) {
                        first = AttributedCharSequence.attr(sb, (s & 0x20) != 0 ? "7" : "27", first);
                    }
                    if ((d & 0x40) != 0) {
                        first = AttributedCharSequence.attr(sb, (s & 0x40) != 0 ? "8" : "28", first);
                    }
                    if ((d & 0x80) != 0) {
                        first = AttributedCharSequence.attr(sb, (s & 0x80) != 0 ? "9" : "29", first);
                    }
                    if (foreground != fg) {
                        if (fg >= 0) {
                            rounded = Colors.roundColor(fg, colors);
                            if (rounded < 8 && !force256colors) {
                                first = AttributedCharSequence.attr(sb, "3" + Integer.toString(rounded), first);
                                d |= s & 1;
                            } else if (rounded < 16 && !force256colors) {
                                first = AttributedCharSequence.attr(sb, "9" + Integer.toString(rounded - 8), first);
                                d |= s & 1;
                            } else {
                                first = AttributedCharSequence.attr(sb, "38;5;" + Integer.toString(rounded), first);
                            }
                        } else {
                            first = AttributedCharSequence.attr(sb, "39", first);
                        }
                        foreground = fg;
                    }
                    if (background != bg) {
                        first = bg >= 0 ? ((rounded = Colors.roundColor(bg, colors)) < 8 && !force256colors ? AttributedCharSequence.attr(sb, "4" + Integer.toString(rounded), first) : (rounded < 16 && !force256colors ? AttributedCharSequence.attr(sb, "10" + Integer.toString(rounded - 8), first) : AttributedCharSequence.attr(sb, "48;5;" + Integer.toString(rounded), first))) : AttributedCharSequence.attr(sb, "49", first);
                        background = bg;
                    }
                    if ((d & 3) != 0) {
                        if ((d & 1) != 0 && (s & 1) == 0 || (d & 2) != 0 && (s & 2) == 0) {
                            first = AttributedCharSequence.attr(sb, "22", first);
                        }
                        if ((d & 1) != 0 && (s & 1) != 0) {
                            first = AttributedCharSequence.attr(sb, "1", first);
                        }
                        if ((d & 2) != 0 && (s & 2) != 0) {
                            first = AttributedCharSequence.attr(sb, "2", first);
                        }
                    }
                    sb.append("m");
                }
                style = s;
            }
            sb.append(c);
        }
        if (alt) {
            sb.append(altOut);
        }
        if (style != 0) {
            sb.append("\u001b[0m");
        }
        return sb.toString();
    }

    private static boolean attr(StringBuilder sb, String s, boolean first) {
        if (!first) {
            sb.append(";");
        }
        sb.append(s);
        return false;
    }

    public abstract AttributedStyle styleAt(int var1);

    int styleCodeAt(int index) {
        return this.styleAt(index).getStyle();
    }

    public boolean isHidden(int index) {
        return (this.styleCodeAt(index) & 0x400) != 0;
    }

    @Override
    public abstract AttributedString subSequence(int var1, int var2);

    public AttributedString substring(int start, int end) {
        return this.subSequence(start, end);
    }

    protected abstract char[] buffer();

    protected abstract int offset();

    @Override
    public char charAt(int index) {
        return this.buffer()[this.offset() + index];
    }

    public int codePointAt(int index) {
        return Character.codePointAt(this.buffer(), index + this.offset());
    }

    public AttributedString columnSubSequence(int start, int stop) {
        int cp;
        int begin = 0;
        int col = 0;
        while (begin < this.length()) {
            int w;
            int cp2 = this.codePointAt(begin);
            int n = w = this.isHidden(begin) ? 0 : WCWidth.wcwidth(cp2);
            if (col + w > start) break;
            begin += Character.charCount(cp2);
            col += w;
        }
        int end = begin;
        while (end < this.length() && (cp = this.codePointAt(end)) != 10) {
            int w;
            int n = w = this.isHidden(end) ? 0 : WCWidth.wcwidth(cp);
            if (col + w > stop) break;
            end += Character.charCount(cp);
            col += w;
        }
        return this.subSequence(begin, end);
    }

    @Override
    public String toString() {
        return new String(this.buffer(), this.offset(), this.length());
    }

    public AttributedString toAttributedString() {
        return this.substring(0, this.length());
    }
}

