/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.cache.shaded.org.jline.terminal.impl;

import coursierapi.shaded.coursier.cache.shaded.org.jline.terminal.Terminal;
import coursierapi.shaded.coursier.cache.shaded.org.jline.terminal.impl.AbstractPosixTerminal;
import coursierapi.shaded.coursier.cache.shaded.org.jline.terminal.spi.Pty;
import coursierapi.shaded.coursier.cache.shaded.org.jline.utils.ClosedException;
import coursierapi.shaded.coursier.cache.shaded.org.jline.utils.NonBlocking;
import coursierapi.shaded.coursier.cache.shaded.org.jline.utils.NonBlockingInputStream;
import coursierapi.shaded.coursier.cache.shaded.org.jline.utils.NonBlockingReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public class PosixPtyTerminal
extends AbstractPosixTerminal {
    private final InputStream in;
    private final OutputStream out;
    private final InputStream masterInput;
    private final OutputStream masterOutput;
    private final NonBlockingInputStream input;
    private final OutputStream output;
    private final NonBlockingReader reader;
    private final PrintWriter writer;
    private final Object lock = new Object();
    private Thread inputPumpThread;
    private Thread outputPumpThread;
    private boolean paused = true;

    public PosixPtyTerminal(String name, String type, Pty pty, InputStream in, OutputStream out, Charset encoding, Terminal.SignalHandler signalHandler, boolean paused) throws IOException {
        super(name, type, pty, encoding, signalHandler);
        this.in = Objects.requireNonNull(in);
        this.out = Objects.requireNonNull(out);
        this.masterInput = pty.getMasterInput();
        this.masterOutput = pty.getMasterOutput();
        this.input = new InputStreamWrapper(NonBlocking.nonBlocking(name, pty.getSlaveInput()));
        this.output = pty.getSlaveOutput();
        this.reader = NonBlocking.nonBlocking(name, this.input, this.encoding());
        this.writer = new PrintWriter(new OutputStreamWriter(this.output, this.encoding()));
        this.parseInfoCmp();
        if (!paused) {
            this.resume();
        }
    }

    @Override
    public PrintWriter writer() {
        return this.writer;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.lock;
        synchronized (object) {
            this.paused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Object object = this.lock;
        synchronized (object) {
            this.paused = false;
            if (this.inputPumpThread == null) {
                this.inputPumpThread = new Thread(this::pumpIn, this.toString() + " input pump thread");
                this.inputPumpThread.setDaemon(true);
                this.inputPumpThread.start();
            }
            if (this.outputPumpThread == null) {
                this.outputPumpThread = new Thread(this::pumpOut, this.toString() + " output pump thread");
                this.outputPumpThread.setDaemon(true);
                this.outputPumpThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pumpIn() {
        try {
            while (true) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.paused) {
                        this.inputPumpThread = null;
                        return;
                    }
                }
                int b = this.in.read();
                if (b < 0) {
                    this.input.close();
                    return;
                }
                this.masterOutput.write(b);
                this.masterOutput.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        finally {
            Object object = this.lock;
            synchronized (object) {
                this.inputPumpThread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pumpOut() {
        try {
            while (true) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.paused) {
                        this.outputPumpThread = null;
                        return;
                    }
                }
                int b = this.masterInput.read();
                if (b < 0) {
                    this.input.close();
                    break;
                }
                this.out.write(b);
                this.out.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            Object object = this.lock;
            synchronized (object) {
                this.outputPumpThread = null;
            }
        }
        try {
            this.close();
            return;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private class InputStreamWrapper
    extends NonBlockingInputStream {
        private final NonBlockingInputStream in;
        private final AtomicBoolean closed = new AtomicBoolean();

        protected InputStreamWrapper(NonBlockingInputStream in) {
            this.in = in;
        }

        @Override
        public int read(long timeout, boolean isPeek) throws IOException {
            if (this.closed.get()) {
                throw new ClosedException();
            }
            return this.in.read(timeout, isPeek);
        }

        @Override
        public void close() throws IOException {
            this.closed.set(true);
        }
    }
}

