/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.cache.shaded.org.fusesource.jansi;

import java.util.ArrayList;
import java.util.concurrent.Callable;

public class Ansi {
    public static final String DISABLE = Ansi.class.getName() + ".disable";
    private static Callable<Boolean> detector = new Callable<Boolean>(){

        @Override
        public Boolean call() throws Exception {
            return !Boolean.getBoolean(DISABLE);
        }
    };
    private static final InheritableThreadLocal<Boolean> holder = new InheritableThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Ansi.isDetected();
        }
    };
    private final StringBuilder builder;
    private final ArrayList<Integer> attributeOptions = new ArrayList(5);

    public static boolean isDetected() {
        try {
            return detector.call();
        }
        catch (Exception e) {
            return true;
        }
    }

    public static boolean isEnabled() {
        return (Boolean)holder.get();
    }

    public static Ansi ansi() {
        if (Ansi.isEnabled()) {
            return new Ansi();
        }
        return new NoAnsi();
    }

    public Ansi() {
        this(new StringBuilder());
    }

    public Ansi(StringBuilder builder) {
        this.builder = builder;
    }

    public Ansi cursorUp(int y) {
        return this.appendEscapeSequence('A', y);
    }

    public Ansi cursorDown(int y) {
        return this.appendEscapeSequence('B', y);
    }

    public Ansi cursorLeft(int x) {
        return this.appendEscapeSequence('D', x);
    }

    public Ansi eraseLine(Erase kind) {
        return this.appendEscapeSequence('K', kind.value());
    }

    public String toString() {
        this.flushAttributes();
        return this.builder.toString();
    }

    private Ansi appendEscapeSequence(char command, int option) {
        this.flushAttributes();
        this.builder.append('\u001b');
        this.builder.append('[');
        this.builder.append(option);
        this.builder.append(command);
        return this;
    }

    private void flushAttributes() {
        if (this.attributeOptions.isEmpty()) {
            return;
        }
        if (this.attributeOptions.size() == 1 && this.attributeOptions.get(0) == 0) {
            this.builder.append('\u001b');
            this.builder.append('[');
            this.builder.append('m');
        } else {
            this._appendEscapeSequence('m', this.attributeOptions.toArray());
        }
        this.attributeOptions.clear();
    }

    private Ansi _appendEscapeSequence(char command, Object ... options) {
        this.builder.append('\u001b');
        this.builder.append('[');
        int size = options.length;
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.builder.append(';');
            }
            if (options[i] == null) continue;
            this.builder.append(options[i]);
        }
        this.builder.append(command);
        return this;
    }

    private static class NoAnsi
    extends Ansi {
        @Override
        public Ansi cursorUp(int y) {
            return this;
        }

        @Override
        public Ansi cursorDown(int y) {
            return this;
        }

        @Override
        public Ansi cursorLeft(int x) {
            return this;
        }

        @Override
        public Ansi eraseLine(Erase kind) {
            return this;
        }
    }

    public static final class Erase
    extends Enum<Erase> {
        public static final /* enum */ Erase FORWARD = new Erase(0, "FORWARD");
        public static final /* enum */ Erase BACKWARD = new Erase(1, "BACKWARD");
        public static final /* enum */ Erase ALL = new Erase(2, "ALL");
        private final int value;
        private final String name;
        private static final /* synthetic */ Erase[] $VALUES;

        private Erase(int index, String name) {
            this.value = index;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public int value() {
            return this.value;
        }

        static {
            $VALUES = new Erase[]{FORWARD, BACKWARD, ALL};
        }
    }
}

