/*
 * Decompiled with CFR 0.152.
 */
package io.druid.java.util.http.client;

import com.google.common.util.concurrent.ListenableFuture;
import io.druid.java.util.common.StringUtils;
import io.druid.java.util.http.client.AbstractHttpClient;
import io.druid.java.util.http.client.HttpClient;
import io.druid.java.util.http.client.Request;
import io.druid.java.util.http.client.response.HttpResponseHandler;
import java.net.URL;
import org.joda.time.Duration;

public class EnforceSslHttpClient
extends AbstractHttpClient {
    private final HttpClient delegate;

    public EnforceSslHttpClient(HttpClient delegate) {
        this.delegate = delegate;
    }

    @Override
    public <Intermediate, Final> ListenableFuture<Final> go(Request request, HttpResponseHandler<Intermediate, Final> handler, Duration requestReadTimeout) {
        URL url = request.getUrl();
        if (!"https".equals(url.getProtocol())) {
            throw new IllegalArgumentException(StringUtils.format("Requests must be over https, got[%s].", url));
        }
        return this.delegate.go(request, handler, requestReadTimeout);
    }
}

