/*
 * Decompiled with CFR 0.152.
 */
package io.druid.java.util.common.guava;

import com.google.common.base.Throwables;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Yielder;
import io.druid.java.util.common.guava.YieldingAccumulator;
import java.io.IOException;

public class Yielders {
    public static <T> Yielder<T> each(Sequence<T> sequence) {
        return sequence.toYielder(null, new YieldingAccumulator<T, T>(){

            @Override
            public T accumulate(T accumulated, T in) {
                this.yield();
                return in;
            }
        });
    }

    public static <T> Yielder<T> done(final T finalVal, final AutoCloseable closeable) {
        return new Yielder<T>(){

            @Override
            public T get() {
                return finalVal;
            }

            @Override
            public Yielder<T> next(T initValue) {
                return null;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public void close() throws IOException {
                if (closeable != null) {
                    try {
                        closeable.close();
                    }
                    catch (Exception e) {
                        Throwables.propagateIfInstanceOf((Throwable)e, IOException.class);
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            }
        };
    }
}

