/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.kafka.supervisor;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import io.druid.indexing.kafka.supervisor.TaskReportData;
import io.druid.indexing.overlord.supervisor.SupervisorReport;
import io.druid.java.util.common.IAE;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class KafkaSupervisorReport
extends SupervisorReport {
    private final KafkaSupervisorReportPayload payload;

    public KafkaSupervisorReport(String dataSource, DateTime generationTime, String topic, Integer partitions, Integer replicas, Long durationSeconds, @Nullable Map<Integer, Long> latestOffsets, @Nullable Map<Integer, Long> minimumLag, @Nullable Long aggregateLag, @Nullable DateTime offsetsLastUpdated) {
        super(dataSource, generationTime);
        this.payload = new KafkaSupervisorReportPayload(dataSource, topic, partitions, replicas, durationSeconds, latestOffsets, minimumLag, aggregateLag, offsetsLastUpdated);
    }

    public Object getPayload() {
        return this.payload;
    }

    public void addTask(TaskReportData data) {
        if (data.getType().equals((Object)TaskReportData.TaskType.ACTIVE)) {
            this.payload.activeTasks.add(data);
        } else if (data.getType().equals((Object)TaskReportData.TaskType.PUBLISHING)) {
            this.payload.publishingTasks.add(data);
        } else {
            throw new IAE("Unknown task type [%s]", new Object[]{data.getType().name()});
        }
    }

    public String toString() {
        return "{id='" + this.getId() + '\'' + ", generationTime=" + this.getGenerationTime() + ", payload=" + this.payload + '}';
    }

    public static class KafkaSupervisorReportPayload {
        private final String dataSource;
        private final String topic;
        private final Integer partitions;
        private final Integer replicas;
        private final Long durationSeconds;
        private final List<TaskReportData> activeTasks;
        private final List<TaskReportData> publishingTasks;
        private final Map<Integer, Long> latestOffsets;
        private final Map<Integer, Long> minimumLag;
        private final Long aggregateLag;
        private final DateTime offsetsLastUpdated;

        public KafkaSupervisorReportPayload(String dataSource, String topic, Integer partitions, Integer replicas, Long durationSeconds, @Nullable Map<Integer, Long> latestOffsets, @Nullable Map<Integer, Long> minimumLag, @Nullable Long aggregateLag, @Nullable DateTime offsetsLastUpdated) {
            this.dataSource = dataSource;
            this.topic = topic;
            this.partitions = partitions;
            this.replicas = replicas;
            this.durationSeconds = durationSeconds;
            this.activeTasks = Lists.newArrayList();
            this.publishingTasks = Lists.newArrayList();
            this.latestOffsets = latestOffsets;
            this.minimumLag = minimumLag;
            this.aggregateLag = aggregateLag;
            this.offsetsLastUpdated = offsetsLastUpdated;
        }

        @JsonProperty
        public String getDataSource() {
            return this.dataSource;
        }

        @JsonProperty
        public String getTopic() {
            return this.topic;
        }

        @JsonProperty
        public Integer getPartitions() {
            return this.partitions;
        }

        @JsonProperty
        public Integer getReplicas() {
            return this.replicas;
        }

        @JsonProperty
        public Long getDurationSeconds() {
            return this.durationSeconds;
        }

        @JsonProperty
        public List<TaskReportData> getActiveTasks() {
            return this.activeTasks;
        }

        @JsonProperty
        public List<TaskReportData> getPublishingTasks() {
            return this.publishingTasks;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public Map<Integer, Long> getLatestOffsets() {
            return this.latestOffsets;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public Map<Integer, Long> getMinimumLag() {
            return this.minimumLag;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public Long getAggregateLag() {
            return this.aggregateLag;
        }

        @JsonProperty
        public DateTime getOffsetsLastUpdated() {
            return this.offsetsLastUpdated;
        }

        public String toString() {
            return "{dataSource='" + this.dataSource + '\'' + ", topic='" + this.topic + '\'' + ", partitions=" + this.partitions + ", replicas=" + this.replicas + ", durationSeconds=" + this.durationSeconds + ", active=" + this.activeTasks + ", publishing=" + this.publishingTasks + (this.latestOffsets != null ? ", latestOffsets=" + this.latestOffsets : "") + (this.minimumLag != null ? ", minimumLag=" + this.minimumLag : "") + (this.aggregateLag != null ? ", aggregateLag=" + this.aggregateLag : "") + (this.offsetsLastUpdated != null ? ", offsetsLastUpdated=" + this.offsetsLastUpdated : "") + '}';
        }
    }
}

