/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.kafka;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.segment.IndexSpec;
import io.druid.segment.indexing.RealtimeTuningConfig;
import io.druid.segment.indexing.TuningConfig;
import io.druid.segment.realtime.appenderator.AppenderatorConfig;
import io.druid.segment.writeout.SegmentWriteOutMediumFactory;
import java.io.File;
import java.util.Objects;
import javax.annotation.Nullable;
import org.joda.time.Period;

public class KafkaTuningConfig
implements TuningConfig,
AppenderatorConfig {
    private static final int DEFAULT_MAX_ROWS_PER_SEGMENT = 5000000;
    private static final boolean DEFAULT_RESET_OFFSET_AUTOMATICALLY = false;
    private final int maxRowsInMemory;
    private final int maxRowsPerSegment;
    private final Period intermediatePersistPeriod;
    private final File basePersistDirectory;
    @Deprecated
    private final int maxPendingPersists;
    private final IndexSpec indexSpec;
    private final boolean reportParseExceptions;
    private final long handoffConditionTimeout;
    private final boolean resetOffsetAutomatically;
    @Nullable
    private final SegmentWriteOutMediumFactory segmentWriteOutMediumFactory;

    @JsonCreator
    public KafkaTuningConfig(@JsonProperty(value="maxRowsInMemory") @Nullable Integer maxRowsInMemory, @JsonProperty(value="maxRowsPerSegment") @Nullable Integer maxRowsPerSegment, @JsonProperty(value="intermediatePersistPeriod") @Nullable Period intermediatePersistPeriod, @JsonProperty(value="basePersistDirectory") @Nullable File basePersistDirectory, @JsonProperty(value="maxPendingPersists") @Nullable Integer maxPendingPersists, @JsonProperty(value="indexSpec") @Nullable IndexSpec indexSpec, @JsonProperty(value="buildV9Directly") @Nullable Boolean buildV9Directly, @JsonProperty(value="reportParseExceptions") @Nullable Boolean reportParseExceptions, @JsonProperty(value="handoffConditionTimeout") @Nullable Long handoffConditionTimeout, @JsonProperty(value="resetOffsetAutomatically") @Nullable Boolean resetOffsetAutomatically, @JsonProperty(value="segmentWriteOutMediumFactory") @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) {
        RealtimeTuningConfig defaults = RealtimeTuningConfig.makeDefaultTuningConfig((File)basePersistDirectory);
        this.maxRowsInMemory = maxRowsInMemory == null ? defaults.getMaxRowsInMemory() : maxRowsInMemory.intValue();
        this.maxRowsPerSegment = maxRowsPerSegment == null ? 5000000 : maxRowsPerSegment;
        this.intermediatePersistPeriod = intermediatePersistPeriod == null ? defaults.getIntermediatePersistPeriod() : intermediatePersistPeriod;
        this.basePersistDirectory = defaults.getBasePersistDirectory();
        this.maxPendingPersists = 0;
        this.indexSpec = indexSpec == null ? defaults.getIndexSpec() : indexSpec;
        this.reportParseExceptions = reportParseExceptions == null ? defaults.isReportParseExceptions() : reportParseExceptions.booleanValue();
        this.handoffConditionTimeout = handoffConditionTimeout == null ? defaults.getHandoffConditionTimeout() : handoffConditionTimeout.longValue();
        this.resetOffsetAutomatically = resetOffsetAutomatically == null ? false : resetOffsetAutomatically;
        this.segmentWriteOutMediumFactory = segmentWriteOutMediumFactory;
    }

    public static KafkaTuningConfig copyOf(KafkaTuningConfig config) {
        return new KafkaTuningConfig(config.maxRowsInMemory, config.maxRowsPerSegment, config.intermediatePersistPeriod, config.basePersistDirectory, config.maxPendingPersists, config.indexSpec, true, config.reportParseExceptions, config.handoffConditionTimeout, config.resetOffsetAutomatically, config.segmentWriteOutMediumFactory);
    }

    @JsonProperty
    public int getMaxRowsInMemory() {
        return this.maxRowsInMemory;
    }

    @JsonProperty
    public int getMaxRowsPerSegment() {
        return this.maxRowsPerSegment;
    }

    @JsonProperty
    public Period getIntermediatePersistPeriod() {
        return this.intermediatePersistPeriod;
    }

    @JsonProperty
    public File getBasePersistDirectory() {
        return this.basePersistDirectory;
    }

    @JsonProperty
    @Deprecated
    public int getMaxPendingPersists() {
        return this.maxPendingPersists;
    }

    @JsonProperty
    public IndexSpec getIndexSpec() {
        return this.indexSpec;
    }

    @Deprecated
    @JsonProperty
    public boolean getBuildV9Directly() {
        return true;
    }

    @JsonProperty
    public boolean isReportParseExceptions() {
        return this.reportParseExceptions;
    }

    @JsonProperty
    public long getHandoffConditionTimeout() {
        return this.handoffConditionTimeout;
    }

    @JsonProperty
    public boolean isResetOffsetAutomatically() {
        return this.resetOffsetAutomatically;
    }

    @JsonProperty
    @Nullable
    public SegmentWriteOutMediumFactory getSegmentWriteOutMediumFactory() {
        return this.segmentWriteOutMediumFactory;
    }

    public KafkaTuningConfig withBasePersistDirectory(File dir) {
        return new KafkaTuningConfig(this.maxRowsInMemory, this.maxRowsPerSegment, this.intermediatePersistPeriod, dir, this.maxPendingPersists, this.indexSpec, true, this.reportParseExceptions, this.handoffConditionTimeout, this.resetOffsetAutomatically, this.segmentWriteOutMediumFactory);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaTuningConfig that = (KafkaTuningConfig)o;
        return this.maxRowsInMemory == that.maxRowsInMemory && this.maxRowsPerSegment == that.maxRowsPerSegment && this.maxPendingPersists == that.maxPendingPersists && this.reportParseExceptions == that.reportParseExceptions && this.handoffConditionTimeout == that.handoffConditionTimeout && this.resetOffsetAutomatically == that.resetOffsetAutomatically && Objects.equals(this.intermediatePersistPeriod, that.intermediatePersistPeriod) && Objects.equals(this.basePersistDirectory, that.basePersistDirectory) && Objects.equals(this.indexSpec, that.indexSpec) && Objects.equals(this.segmentWriteOutMediumFactory, that.segmentWriteOutMediumFactory);
    }

    public int hashCode() {
        return Objects.hash(this.maxRowsInMemory, this.maxRowsPerSegment, this.intermediatePersistPeriod, this.basePersistDirectory, this.maxPendingPersists, this.indexSpec, this.reportParseExceptions, this.handoffConditionTimeout, this.resetOffsetAutomatically, this.segmentWriteOutMediumFactory);
    }

    public String toString() {
        return "KafkaTuningConfig{maxRowsInMemory=" + this.maxRowsInMemory + ", maxRowsPerSegment=" + this.maxRowsPerSegment + ", intermediatePersistPeriod=" + this.intermediatePersistPeriod + ", basePersistDirectory=" + this.basePersistDirectory + ", maxPendingPersists=" + this.maxPendingPersists + ", indexSpec=" + this.indexSpec + ", reportParseExceptions=" + this.reportParseExceptions + ", handoffConditionTimeout=" + this.handoffConditionTimeout + ", resetOffsetAutomatically=" + this.resetOffsetAutomatically + ", segmentWriteOutMediumFactory=" + this.segmentWriteOutMediumFactory + '}';
    }
}

