/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.kafka;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.druid.indexing.kafka.KafkaPartitions;
import io.druid.segment.indexing.IOConfig;
import java.util.Map;
import org.joda.time.DateTime;

public class KafkaIOConfig
implements IOConfig {
    private static final boolean DEFAULT_USE_TRANSACTION = true;
    private static final boolean DEFAULT_PAUSE_AFTER_READ = false;
    private static final boolean DEFAULT_SKIP_OFFSET_GAPS = false;
    private final String baseSequenceName;
    private final KafkaPartitions startPartitions;
    private final KafkaPartitions endPartitions;
    private final Map<String, String> consumerProperties;
    private final boolean useTransaction;
    private final boolean pauseAfterRead;
    private final Optional<DateTime> minimumMessageTime;
    private final Optional<DateTime> maximumMessageTime;
    private final boolean skipOffsetGaps;

    @JsonCreator
    public KafkaIOConfig(@JsonProperty(value="baseSequenceName") String baseSequenceName, @JsonProperty(value="startPartitions") KafkaPartitions startPartitions, @JsonProperty(value="endPartitions") KafkaPartitions endPartitions, @JsonProperty(value="consumerProperties") Map<String, String> consumerProperties, @JsonProperty(value="useTransaction") Boolean useTransaction, @JsonProperty(value="pauseAfterRead") Boolean pauseAfterRead, @JsonProperty(value="minimumMessageTime") DateTime minimumMessageTime, @JsonProperty(value="maximumMessageTime") DateTime maximumMessageTime, @JsonProperty(value="skipOffsetGaps") Boolean skipOffsetGaps) {
        this.baseSequenceName = (String)Preconditions.checkNotNull((Object)baseSequenceName, (Object)"baseSequenceName");
        this.startPartitions = (KafkaPartitions)Preconditions.checkNotNull((Object)startPartitions, (Object)"startPartitions");
        this.endPartitions = (KafkaPartitions)Preconditions.checkNotNull((Object)endPartitions, (Object)"endPartitions");
        this.consumerProperties = (Map)Preconditions.checkNotNull(consumerProperties, (Object)"consumerProperties");
        this.useTransaction = useTransaction != null ? useTransaction : true;
        this.pauseAfterRead = pauseAfterRead != null ? pauseAfterRead : false;
        this.minimumMessageTime = Optional.fromNullable((Object)minimumMessageTime);
        this.maximumMessageTime = Optional.fromNullable((Object)maximumMessageTime);
        this.skipOffsetGaps = skipOffsetGaps != null ? skipOffsetGaps : false;
        Preconditions.checkArgument((boolean)startPartitions.getTopic().equals(endPartitions.getTopic()), (Object)"start topic and end topic must match");
        Preconditions.checkArgument((boolean)startPartitions.getPartitionOffsetMap().keySet().equals(endPartitions.getPartitionOffsetMap().keySet()), (Object)"start partition set and end partition set must match");
        for (int partition : endPartitions.getPartitionOffsetMap().keySet()) {
            Preconditions.checkArgument((endPartitions.getPartitionOffsetMap().get(partition) >= startPartitions.getPartitionOffsetMap().get(partition) ? 1 : 0) != 0, (String)"end offset must be >= start offset for partition[%s]", (Object[])new Object[]{partition});
        }
    }

    @JsonProperty
    public String getBaseSequenceName() {
        return this.baseSequenceName;
    }

    @JsonProperty
    public KafkaPartitions getStartPartitions() {
        return this.startPartitions;
    }

    @JsonProperty
    public KafkaPartitions getEndPartitions() {
        return this.endPartitions;
    }

    @JsonProperty
    public Map<String, String> getConsumerProperties() {
        return this.consumerProperties;
    }

    @JsonProperty
    public boolean isUseTransaction() {
        return this.useTransaction;
    }

    @JsonProperty
    public boolean isPauseAfterRead() {
        return this.pauseAfterRead;
    }

    @JsonProperty
    public Optional<DateTime> getMaximumMessageTime() {
        return this.maximumMessageTime;
    }

    @JsonProperty
    public Optional<DateTime> getMinimumMessageTime() {
        return this.minimumMessageTime;
    }

    @JsonProperty
    public boolean isSkipOffsetGaps() {
        return this.skipOffsetGaps;
    }

    public String toString() {
        return "KafkaIOConfig{baseSequenceName='" + this.baseSequenceName + '\'' + ", startPartitions=" + this.startPartitions + ", endPartitions=" + this.endPartitions + ", consumerProperties=" + this.consumerProperties + ", useTransaction=" + this.useTransaction + ", pauseAfterRead=" + this.pauseAfterRead + ", minimumMessageTime=" + this.minimumMessageTime + ", maximumMessageTime=" + this.maximumMessageTime + ", skipOffsetGaps=" + this.skipOffsetGaps + '}';
    }
}

