/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.jdbi3.strategies;

import com.codahale.metrics.jdbi3.strategies.StatementNameStrategy;
import java.util.Arrays;
import java.util.List;
import org.jdbi.v3.core.statement.StatementContext;

public abstract class DelegatingStatementNameStrategy
implements StatementNameStrategy {
    private static final String UNKNOWN_SQL = "sql.unknown";
    private final List<StatementNameStrategy> strategies;

    protected DelegatingStatementNameStrategy(StatementNameStrategy ... strategies) {
        this.strategies = Arrays.asList(strategies);
    }

    @Override
    public String getStatementName(StatementContext statementContext) {
        for (StatementNameStrategy strategy : this.strategies) {
            String statementName = strategy.getStatementName(statementContext);
            if (statementName == null) continue;
            return statementName;
        }
        return UNKNOWN_SQL;
    }
}

