/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.views;

import io.dropwizard.views.ViewRenderException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.glassfish.jersey.spi.ExtendedExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class ViewRenderExceptionMapper
implements ExtendedExceptionMapper<WebApplicationException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ViewRenderExceptionMapper.class);
    public static final String TEMPLATE_ERROR_MSG = "<html><head><title>Template Error</title></head><body><h1>Template Error</h1><p>Something went wrong rendering the page</p></body></html>";

    public Response toResponse(WebApplicationException exception) {
        LOGGER.error("Template Error", (Throwable)exception);
        return Response.serverError().type(MediaType.TEXT_HTML_TYPE).entity((Object)TEMPLATE_ERROR_MSG).build();
    }

    public boolean isMappable(WebApplicationException e) {
        return ExceptionUtils.indexOfThrowable((Throwable)e, ViewRenderException.class) != -1;
    }
}

