/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.db;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import io.dropwizard.db.ManagedDataSource;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import org.apache.tomcat.jdbc.pool.ConnectionPool;
import org.apache.tomcat.jdbc.pool.DataSourceProxy;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;

public class ManagedPooledDataSource
extends DataSourceProxy
implements ManagedDataSource {
    private final MetricRegistry metricRegistry;

    public ManagedPooledDataSource(PoolConfiguration config, MetricRegistry metricRegistry) {
        super(config);
        this.metricRegistry = metricRegistry;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Doesn't use java.util.logging");
    }

    public void start() throws Exception {
        ConnectionPool connectionPool = this.createPool();
        this.metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{connectionPool.getName(), "active"}), (Metric)((Gauge)() -> ((ConnectionPool)connectionPool).getActive()));
        this.metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{connectionPool.getName(), "idle"}), (Metric)((Gauge)() -> ((ConnectionPool)connectionPool).getIdle()));
        this.metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{connectionPool.getName(), "waiting"}), (Metric)((Gauge)() -> ((ConnectionPool)connectionPool).getWaitCount()));
        this.metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{connectionPool.getName(), "size"}), (Metric)((Gauge)() -> ((ConnectionPool)connectionPool).getSize()));
        this.metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{connectionPool.getName(), "created"}), (Metric)((Gauge)() -> ((ConnectionPool)connectionPool).getCreatedCount()));
        this.metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{connectionPool.getName(), "borrowed"}), (Metric)((Gauge)() -> ((ConnectionPool)connectionPool).getBorrowedCount()));
        this.metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{connectionPool.getName(), "reconnected"}), (Metric)((Gauge)() -> ((ConnectionPool)connectionPool).getReconnectedCount()));
        this.metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{connectionPool.getName(), "released"}), (Metric)((Gauge)() -> ((ConnectionPool)connectionPool).getReleasedCount()));
        this.metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{connectionPool.getName(), "releasedIdle"}), (Metric)((Gauge)() -> ((ConnectionPool)connectionPool).getReleasedIdleCount()));
        this.metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{connectionPool.getName(), "returned"}), (Metric)((Gauge)() -> ((ConnectionPool)connectionPool).getReturnedCount()));
        this.metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{connectionPool.getName(), "removeAbandoned"}), (Metric)((Gauge)() -> ((ConnectionPool)connectionPool).getRemoveAbandonedCount()));
    }

    public void stop() throws Exception {
        this.close();
    }
}

