/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.client;

import io.dropwizard.util.DirectExecutorService;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import org.apache.hc.core5.util.VersionInfo;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.message.internal.Statuses;

public class DropwizardApacheConnector
implements Connector {
    private static final String ERROR_BUFFERING_ENTITY = "Error buffering the entity.";
    private static final String APACHE_HTTP_CLIENT_VERSION = VersionInfo.loadVersionInfo((String)"org.apache.hc.client5", (ClassLoader)DropwizardApacheConnector.class.getClassLoader()).getRelease();
    private final CloseableHttpClient client;
    private final @Nullable RequestConfig defaultRequestConfig;
    private final boolean chunkedEncodingEnabled;

    public DropwizardApacheConnector(CloseableHttpClient client, @Nullable RequestConfig defaultRequestConfig, boolean chunkedEncodingEnabled) {
        this.client = client;
        this.defaultRequestConfig = defaultRequestConfig;
        this.chunkedEncodingEnabled = chunkedEncodingEnabled;
    }

    public ClientResponse apply(ClientRequest jerseyRequest) {
        try {
            HttpUriRequest apacheRequest = this.buildApacheRequest(jerseyRequest);
            CloseableHttpResponse apacheResponse = this.client.execute((ClassicHttpRequest)apacheRequest);
            String reasonPhrase = apacheResponse.getReasonPhrase();
            Response.StatusType status = Statuses.from((int)apacheResponse.getCode(), (String)(reasonPhrase == null ? "" : reasonPhrase));
            ClientResponse jerseyResponse = new ClientResponse(status, jerseyRequest);
            for (Header header : apacheResponse.getHeaders()) {
                ((List)jerseyResponse.getHeaders().computeIfAbsent((Object)header.getName(), k -> new ArrayList())).add(header.getValue());
            }
            HttpEntity httpEntity = apacheResponse.getEntity();
            jerseyResponse.setEntityStream(httpEntity != null ? httpEntity.getContent() : new ByteArrayInputStream(new byte[0]));
            return jerseyResponse;
        }
        catch (Exception e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    private HttpUriRequest buildApacheRequest(ClientRequest jerseyRequest) {
        HttpUriRequestBase base = new HttpUriRequestBase(jerseyRequest.getMethod(), jerseyRequest.getUri());
        base.setEntity(this.getHttpEntity(jerseyRequest));
        for (String headerName : jerseyRequest.getHeaders().keySet()) {
            base.addHeader(headerName, (Object)jerseyRequest.getHeaderString(headerName));
        }
        Optional<RequestConfig> requestConfig = this.addJerseyRequestConfig(jerseyRequest);
        requestConfig.ifPresent(arg_0 -> ((HttpUriRequestBase)base).setConfig(arg_0));
        return base;
    }

    private Optional<RequestConfig> addJerseyRequestConfig(ClientRequest clientRequest) {
        Integer timeout = (Integer)clientRequest.resolveProperty("jersey.config.client.readTimeout", Integer.class);
        Integer connectTimeout = (Integer)clientRequest.resolveProperty("jersey.config.client.connectTimeout", Integer.class);
        Boolean followRedirects = (Boolean)clientRequest.resolveProperty("jersey.config.client.followRedirects", Boolean.class);
        if (timeout != null || connectTimeout != null || followRedirects != null) {
            RequestConfig.Builder requestConfig = RequestConfig.copy((RequestConfig)this.defaultRequestConfig);
            if (timeout != null) {
                requestConfig.setResponseTimeout((long)timeout.intValue(), TimeUnit.MILLISECONDS);
            }
            if (connectTimeout != null) {
                requestConfig.setConnectTimeout((long)connectTimeout.intValue(), TimeUnit.MILLISECONDS);
            }
            if (followRedirects != null) {
                requestConfig.setRedirectsEnabled(followRedirects.booleanValue());
            }
            return Optional.of(requestConfig.build());
        }
        return Optional.empty();
    }

    protected @Nullable HttpEntity getHttpEntity(ClientRequest jerseyRequest) {
        if (jerseyRequest.getEntity() == null) {
            return null;
        }
        return this.chunkedEncodingEnabled ? new JerseyRequestHttpEntity(jerseyRequest) : new BufferedJerseyRequestHttpEntity(jerseyRequest);
    }

    public Future<?> apply(ClientRequest request, AsyncConnectorCallback callback) {
        return new DirectExecutorService().submit(() -> {
            try {
                callback.response(this.apply(request));
            }
            catch (Exception e) {
                callback.failure((Throwable)e);
            }
        });
    }

    public String getName() {
        return "Apache-HttpClient/" + APACHE_HTTP_CLIENT_VERSION;
    }

    public void close() {
    }

    private static @Nullable String getEncoding(ClientRequest clientRequest) {
        List contentEncoding = clientRequest.getRequestHeader("Content-Encoding");
        if (contentEncoding == null) {
            return null;
        }
        return contentEncoding.stream().findFirst().orElse(null);
    }

    private static class BufferedJerseyRequestHttpEntity
    extends AbstractHttpEntity {
        private static final int BUFFER_INITIAL_SIZE = 512;
        private byte[] buffer;

        private BufferedJerseyRequestHttpEntity(ClientRequest clientRequest) {
            super(clientRequest.getMediaType().toString(), DropwizardApacheConnector.getEncoding(clientRequest), false);
            ByteArrayOutputStream stream = new ByteArrayOutputStream(512);
            clientRequest.setStreamProvider(contentLength -> stream);
            try {
                clientRequest.writeEntity();
            }
            catch (IOException e) {
                throw new ProcessingException(DropwizardApacheConnector.ERROR_BUFFERING_ENTITY, (Throwable)e);
            }
            this.buffer = stream.toByteArray();
        }

        public boolean isRepeatable() {
            return true;
        }

        public long getContentLength() {
            return this.buffer.length;
        }

        public InputStream getContent() throws IOException {
            throw new UnsupportedOperationException("Reading from the entity is not supported");
        }

        public void writeTo(OutputStream outstream) throws IOException {
            outstream.write(this.buffer);
            outstream.flush();
        }

        public boolean isStreaming() {
            return false;
        }

        public void close() throws IOException {
        }
    }

    private static class JerseyRequestHttpEntity
    extends AbstractHttpEntity {
        private final ClientRequest clientRequest;

        private JerseyRequestHttpEntity(ClientRequest clientRequest) {
            super(clientRequest.getMediaType().toString(), DropwizardApacheConnector.getEncoding(clientRequest), true);
            this.clientRequest = clientRequest;
        }

        public boolean isRepeatable() {
            return false;
        }

        public long getContentLength() {
            return -1L;
        }

        public InputStream getContent() throws IOException {
            throw new UnsupportedOperationException("Reading from the entity is not supported");
        }

        public void writeTo(OutputStream outputStream) throws IOException {
            this.clientRequest.setStreamProvider(contentLength -> outputStream);
            this.clientRequest.writeEntity();
        }

        public boolean isStreaming() {
            return false;
        }

        public void close() throws IOException {
        }
    }
}

