/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth;

import jakarta.annotation.Priority;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import java.io.IOException;
import java.util.Objects;

@Priority(value=1000)
class WebApplicationExceptionCatchingFilter
implements ContainerRequestFilter {
    private final ContainerRequestFilter underlying;

    public WebApplicationExceptionCatchingFilter(ContainerRequestFilter underlying) {
        Objects.requireNonNull(underlying, "Underlying ContainerRequestFilter is not set");
        this.underlying = underlying;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        try {
            this.underlying.filter(requestContext);
        }
        catch (WebApplicationException webApplicationException) {
            // empty catch block
        }
    }
}

