/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.serializer.collection;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.TypeSerializer;
import java.util.List;

public abstract class ListSerializer<T extends List>
implements TypeSerializer<T> {
    protected abstract T createList(int var1);

    @Override
    public void write(T object, BufferOutput buffer, Serializer serializer) {
        buffer.writeUnsignedShort(object.size());
        for (Object value : object) {
            serializer.writeObject(value, buffer);
        }
    }

    @Override
    public T read(Class<T> type, BufferInput buffer, Serializer serializer) {
        int size = buffer.readUnsignedShort();
        T object = this.createList(size);
        for (int i = 0; i < size; ++i) {
            object.add(serializer.readObject(buffer));
        }
        return object;
    }
}

