/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.serializer.buffer;

import io.atomix.catalyst.buffer.BufferDataInput;
import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.serializer.Serializer;
import java.io.IOException;
import java.io.ObjectInput;

public class BufferObjectInput
extends BufferDataInput
implements ObjectInput {
    private final Serializer serializer;

    public BufferObjectInput(BufferInput<?> buffer, Serializer serializer) {
        super(buffer);
        if (serializer == null) {
            throw new NullPointerException("serializer cannot be null");
        }
        this.serializer = serializer;
    }

    @Override
    public Object readObject() throws ClassNotFoundException, IOException {
        return this.serializer.readObject(this.buffer);
    }

    @Override
    public int read() throws IOException {
        return this.buffer.readByte();
    }

    @Override
    public int read(byte[] b) throws IOException {
        int i = 0;
        while (i < b.length && this.buffer.hasRemaining()) {
            b[i++] = (byte)this.buffer.readByte();
        }
        return i;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i = 0;
        while (i < len && this.buffer.hasRemaining()) {
            b[i + off] = (byte)this.buffer.readByte();
        }
        return i;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = Math.min(n, this.buffer.remaining());
        this.buffer.skip(skipped);
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return (int)this.buffer.remaining();
    }

    @Override
    public void close() throws IOException {
        this.buffer.close();
    }
}

