/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer;

import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.BufferPool;
import io.atomix.catalyst.buffer.UnsafeDirectBuffer;
import io.atomix.catalyst.buffer.UnsafeDirectBytes;
import io.atomix.catalyst.util.reference.ReferenceCounted;
import io.atomix.catalyst.util.reference.ReferenceFactory;
import io.atomix.catalyst.util.reference.ReferenceManager;

public class UnsafeDirectBufferPool
extends BufferPool {
    public UnsafeDirectBufferPool() {
        super(new DirectBufferFactory());
    }

    public void release(Buffer reference) {
        reference.rewind();
        super.release((ReferenceCounted)reference);
    }

    private static class DirectBufferFactory
    implements ReferenceFactory<Buffer> {
        private DirectBufferFactory() {
        }

        public Buffer createReference(ReferenceManager<Buffer> manager) {
            UnsafeDirectBuffer buffer = new UnsafeDirectBuffer(UnsafeDirectBytes.allocate(1024L), manager);
            buffer.reset(0L, 1024L, Long.MAX_VALUE);
            return buffer;
        }
    }
}

