/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer;

import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.NativeBuffer;
import io.atomix.catalyst.buffer.UnsafeDirectBytes;
import io.atomix.catalyst.buffer.util.DirectMemory;
import io.atomix.catalyst.buffer.util.Memory;
import io.atomix.catalyst.util.reference.ReferenceManager;

public class UnsafeDirectBuffer
extends NativeBuffer {
    public static UnsafeDirectBuffer allocate() {
        return UnsafeDirectBuffer.allocate(4096L, Long.MAX_VALUE);
    }

    public static UnsafeDirectBuffer allocate(long initialCapacity) {
        return UnsafeDirectBuffer.allocate(initialCapacity, Long.MAX_VALUE);
    }

    public static UnsafeDirectBuffer allocate(long initialCapacity, long maxCapacity) {
        if (initialCapacity > maxCapacity) {
            throw new IllegalArgumentException("initial capacity cannot be greater than maximum capacity");
        }
        return new UnsafeDirectBuffer(new UnsafeDirectBytes(DirectMemory.allocate(Memory.Util.toPow2(initialCapacity))), 0L, initialCapacity, maxCapacity);
    }

    protected UnsafeDirectBuffer(UnsafeDirectBytes bytes, long offset, long initialCapacity, long maxCapacity) {
        super(bytes, offset, initialCapacity, maxCapacity);
    }

    protected UnsafeDirectBuffer(UnsafeDirectBytes bytes, ReferenceManager<Buffer> referenceManager) {
        super(bytes, referenceManager);
    }
}

