/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer;

import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.buffer.BufferOutputStream;
import java.io.DataOutput;

public class BufferDataOutput
extends BufferOutputStream
implements DataOutput {
    protected final BufferOutput<?> buffer;

    public BufferDataOutput(BufferOutput<?> buffer) {
        super(buffer);
        if (buffer == null) {
            throw new NullPointerException("buffer cannot be null");
        }
        this.buffer = buffer;
    }

    @Override
    public void write(int b) {
        this.buffer.writeByte(b);
    }

    @Override
    public void write(byte[] b) {
        this.buffer.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.buffer.write(b, (long)off, (long)len);
    }

    @Override
    public void writeBoolean(boolean b) {
        this.buffer.writeBoolean(b);
    }

    @Override
    public void writeByte(int b) {
        this.buffer.writeByte(b);
    }

    @Override
    public void writeShort(int s) {
        this.buffer.writeShort((short)s);
    }

    @Override
    public void writeChar(int c) {
        this.buffer.writeChar((char)c);
    }

    @Override
    public void writeInt(int i) {
        this.buffer.writeInt(i);
    }

    @Override
    public void writeLong(long l) {
        this.buffer.writeLong(l);
    }

    @Override
    public void writeFloat(float f) {
        this.buffer.writeFloat(f);
    }

    @Override
    public void writeDouble(double d) {
        this.buffer.writeDouble(d);
    }

    @Override
    public void writeBytes(String s) {
        this.buffer.write(s.getBytes());
    }

    @Override
    public void writeChars(String s) {
        for (char c : s.toCharArray()) {
            this.buffer.writeChar(c);
        }
    }

    @Override
    public void writeUTF(String s) {
        this.buffer.writeUTF8(s);
    }
}

