/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer;

import io.atomix.catalyst.buffer.Bytes;
import io.atomix.catalyst.buffer.SwappedBytes;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public abstract class AbstractBytes
implements Bytes {
    private boolean open = true;
    private SwappedBytes swap;

    protected void checkOpen() {
        if (!this.open) {
            throw new IllegalStateException("bytes not open");
        }
    }

    protected void checkOffset(long offset) {
        this.checkOpen();
        if (offset < 0L || offset > this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }

    protected long checkRead(long offset, long length) {
        this.checkOffset(offset);
        long position = offset + length;
        if (position > this.size()) {
            throw new BufferUnderflowException();
        }
        return position;
    }

    protected long checkWrite(long offset, long length) {
        this.checkOffset(offset);
        long position = offset + length;
        if (position > this.size()) {
            throw new BufferOverflowException();
        }
        return position;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public Bytes order(ByteOrder order) {
        if (order == null) {
            throw new NullPointerException("order cannot be null");
        }
        if (order == this.order()) {
            return this;
        }
        if (this.swap != null) {
            return this.swap;
        }
        this.swap = new SwappedBytes(this);
        return this.swap;
    }

    @Override
    public boolean readBoolean(long offset) {
        return this.readByte(offset) == 1;
    }

    @Override
    public int readUnsignedByte(long offset) {
        return this.readByte(offset) & 0xFF;
    }

    @Override
    public int readUnsignedShort(long offset) {
        return this.readShort(offset) & 0xFFFF;
    }

    @Override
    public int readMedium(long offset) {
        return this.readByte(offset) << 16 | (this.readByte(offset + 1L) & 0xFF) << 8 | this.readByte(offset + 2L) & 0xFF;
    }

    @Override
    public int readUnsignedMedium(long offset) {
        return (this.readByte(offset) & 0xFF) << 16 | (this.readByte(offset + 1L) & 0xFF) << 8 | this.readByte(offset + 2L) & 0xFF;
    }

    @Override
    public long readUnsignedInt(long offset) {
        return (long)this.readInt(offset) & 0xFFFFFFFFL;
    }

    @Override
    public String readString(long offset) {
        return this.readString(offset, Charset.defaultCharset());
    }

    @Override
    public String readString(long offset, Charset charset) {
        if (this.readBoolean(offset)) {
            byte[] bytes = new byte[this.readUnsignedShort(offset + 1L)];
            this.read(offset + 1L + 2L, bytes, 0L, (long)bytes.length);
            return new String(bytes, charset);
        }
        return null;
    }

    @Override
    public String readUTF8(long offset) {
        return this.readString(offset, StandardCharsets.UTF_8);
    }

    @Override
    public Bytes writeBoolean(long offset, boolean b) {
        return (Bytes)this.writeByte(offset, b ? 1 : 0);
    }

    @Override
    public Bytes writeUnsignedByte(long offset, int b) {
        return (Bytes)this.writeByte(offset, (byte)b);
    }

    @Override
    public Bytes writeUnsignedShort(long offset, int s) {
        return (Bytes)this.writeShort(offset, (short)s);
    }

    @Override
    public Bytes writeMedium(long offset, int m) {
        this.writeByte(offset, (byte)(m >>> 16));
        this.writeByte(offset + 1L, (byte)(m >>> 8));
        this.writeByte(offset + 2L, (byte)m);
        return this;
    }

    @Override
    public Bytes writeUnsignedMedium(long offset, int m) {
        return this.writeMedium(offset, m);
    }

    @Override
    public Bytes writeUnsignedInt(long offset, long i) {
        return (Bytes)this.writeInt(offset, (int)i);
    }

    @Override
    public Bytes writeString(long offset, String s) {
        return this.writeString(offset, s, Charset.defaultCharset());
    }

    @Override
    public Bytes writeString(long offset, String s, Charset charset) {
        if (s == null) {
            return this.writeBoolean(offset, Boolean.FALSE);
        }
        this.writeBoolean(offset, Boolean.TRUE);
        byte[] bytes = s.getBytes(charset);
        return (Bytes)this.writeUnsignedShort(offset + 1L, bytes.length).write(offset + 1L + 2L, bytes, 0L, (long)bytes.length);
    }

    @Override
    public Bytes writeUTF8(long offset, String s) {
        return this.writeString(offset, s, StandardCharsets.UTF_8);
    }

    @Override
    public Bytes flush() {
        return this;
    }

    @Override
    public void close() {
        this.open = false;
    }
}

