/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.buffer;

import com.google.common.base.Preconditions;
import io.atomix.storage.buffer.AbstractBuffer;
import io.atomix.storage.buffer.Buffer;
import io.atomix.storage.buffer.UnsafeHeapBytes;
import io.atomix.utils.concurrent.ReferenceManager;
import io.atomix.utils.memory.HeapMemory;
import io.atomix.utils.memory.Memory;

public class UnsafeHeapBuffer
extends AbstractBuffer {
    private final UnsafeHeapBytes bytes;

    public static UnsafeHeapBuffer allocate() {
        return UnsafeHeapBuffer.allocate(4096, 0x7FFFFFFA);
    }

    public static UnsafeHeapBuffer allocate(int initialCapacity) {
        return UnsafeHeapBuffer.allocate(initialCapacity, 0x7FFFFFFA);
    }

    public static UnsafeHeapBuffer allocate(int initialCapacity, int maxCapacity) {
        Preconditions.checkArgument((initialCapacity <= maxCapacity ? 1 : 0) != 0, (Object)"initial capacity cannot be greater than maximum capacity");
        return new UnsafeHeapBuffer(new UnsafeHeapBytes(HeapMemory.allocate((int)((int)Math.min(Memory.Util.toPow2((int)initialCapacity), (long)maxCapacity)))), 0, initialCapacity, maxCapacity);
    }

    public static UnsafeHeapBuffer wrap(byte[] bytes) {
        return new UnsafeHeapBuffer(UnsafeHeapBytes.wrap(bytes), 0, bytes.length, bytes.length);
    }

    protected UnsafeHeapBuffer(UnsafeHeapBytes bytes, ReferenceManager<Buffer> referenceManager) {
        super(bytes, referenceManager);
        this.bytes = bytes;
    }

    protected UnsafeHeapBuffer(UnsafeHeapBytes bytes, int offset, int initialCapacity, int maxCapacity) {
        super(bytes, offset, initialCapacity, maxCapacity, null);
        this.bytes = bytes;
    }

    @Override
    protected void compact(int from, int to, int length) {
        this.bytes.memory.unsafe().copyMemory(this.bytes.memory.array(), this.bytes.memory.address(from), this.bytes.memory.array(), this.bytes.memory.address(to), length);
        this.bytes.memory.unsafe().setMemory(this.bytes.memory.array(), this.bytes.memory.address(from), length, (byte)0);
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    @Override
    public byte[] array() {
        return this.bytes.memory.array();
    }

    public UnsafeHeapBuffer reset(byte[] array) {
        this.bytes.memory.reset(array);
        this.clear();
        return this;
    }

    @Override
    public UnsafeHeapBuffer duplicate() {
        return new UnsafeHeapBuffer(this.bytes, this.offset(), this.capacity(), this.maxCapacity());
    }
}

