/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.buffer;

import com.google.common.base.Preconditions;
import io.atomix.storage.buffer.Buffer;
import io.atomix.storage.buffer.NativeBuffer;
import io.atomix.storage.buffer.UnsafeDirectBytes;
import io.atomix.utils.concurrent.ReferenceManager;
import io.atomix.utils.memory.DirectMemory;
import io.atomix.utils.memory.Memory;

public class UnsafeDirectBuffer
extends NativeBuffer {
    public static UnsafeDirectBuffer allocate() {
        return UnsafeDirectBuffer.allocate(4096, Integer.MAX_VALUE);
    }

    public static UnsafeDirectBuffer allocate(int initialCapacity) {
        return UnsafeDirectBuffer.allocate(initialCapacity, Integer.MAX_VALUE);
    }

    public static UnsafeDirectBuffer allocate(int initialCapacity, int maxCapacity) {
        Preconditions.checkArgument((initialCapacity <= maxCapacity ? 1 : 0) != 0, (Object)"initial capacity cannot be greater than maximum capacity");
        return new UnsafeDirectBuffer(new UnsafeDirectBytes(DirectMemory.allocate((int)((int)Math.min(Memory.Util.toPow2((int)initialCapacity), (long)maxCapacity)))), 0, initialCapacity, maxCapacity);
    }

    protected UnsafeDirectBuffer(UnsafeDirectBytes bytes, int offset, int initialCapacity, int maxCapacity) {
        super(bytes, offset, initialCapacity, maxCapacity);
    }

    protected UnsafeDirectBuffer(UnsafeDirectBytes bytes, ReferenceManager<Buffer> referenceManager) {
        super(bytes, referenceManager);
    }

    @Override
    public UnsafeDirectBuffer duplicate() {
        return new UnsafeDirectBuffer((UnsafeDirectBytes)this.bytes, this.offset(), this.capacity(), this.maxCapacity());
    }
}

