/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.impl;

import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.PrimitiveTypeRegistry;
import io.atomix.utils.ServiceException;
import io.atomix.utils.misc.StringUtils;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathScanningPrimitiveTypeRegistry
implements PrimitiveTypeRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathScanningPrimitiveTypeRegistry.class);
    private static final Map<ClassLoader, Map<String, PrimitiveType>> CACHE = Collections.synchronizedMap(new WeakHashMap());
    private final Map<String, PrimitiveType> primitiveTypes = new ConcurrentHashMap<String, PrimitiveType>();

    public ClasspathScanningPrimitiveTypeRegistry(ClassLoader classLoader) {
        Map types = CACHE.computeIfAbsent(classLoader, cl -> {
            ConcurrentHashMap result = new ConcurrentHashMap();
            String[] whitelistPackages = StringUtils.split((String)System.getProperty("io.atomix.whitelistPackages"), (String)",");
            ClassGraph classGraph = whitelistPackages != null ? new ClassGraph().enableClassInfo().whitelistPackages(whitelistPackages).addClassLoader(classLoader) : new ClassGraph().enableClassInfo().addClassLoader(classLoader);
            try (ScanResult scanResult = classGraph.scan();){
                scanResult.getClassesImplementing(PrimitiveType.class.getName()).forEach(classInfo -> {
                    if (classInfo.isInterface() || classInfo.isAbstract() || Modifier.isPrivate(classInfo.getModifiers())) {
                        return;
                    }
                    PrimitiveType primitiveType = (PrimitiveType)ClasspathScanningPrimitiveTypeRegistry.newInstance(classInfo.loadClass());
                    PrimitiveType oldPrimitiveType = result.put(primitiveType.name(), primitiveType);
                    if (oldPrimitiveType != null) {
                        LOGGER.warn("Found multiple primitives types name={}, classes=[{}, {}]", new Object[]{primitiveType.name(), oldPrimitiveType.getClass().getName(), primitiveType.getClass().getName()});
                    }
                });
            }
            return Collections.unmodifiableMap(result);
        });
        this.primitiveTypes.putAll(types);
    }

    private static <T> T newInstance(Class<?> type) {
        try {
            return (T)type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ServiceException("Cannot instantiate service class " + type, (Throwable)e);
        }
    }

    @Override
    public Collection<PrimitiveType> getPrimitiveTypes() {
        return this.primitiveTypes.values();
    }

    @Override
    public PrimitiveType getPrimitiveType(String typeName) {
        PrimitiveType type = this.primitiveTypes.get(typeName);
        if (type == null) {
            throw new ServiceException("Unknown primitive type " + typeName);
        }
        return type;
    }
}

