/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.service;

import com.google.common.collect.Maps;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.PrimitiveId;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.operation.OperationId;
import io.atomix.primitive.operation.Operations;
import io.atomix.primitive.service.Commit;
import io.atomix.primitive.service.PrimitiveService;
import io.atomix.primitive.service.ServiceContext;
import io.atomix.primitive.service.ServiceExecutor;
import io.atomix.primitive.service.impl.DefaultServiceExecutor;
import io.atomix.primitive.session.Session;
import io.atomix.primitive.session.SessionId;
import io.atomix.primitive.session.impl.ClientSession;
import io.atomix.utils.concurrent.Scheduler;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import io.atomix.utils.time.Clock;
import io.atomix.utils.time.LogicalClock;
import io.atomix.utils.time.WallClock;
import io.atomix.utils.time.WallClockTimestamp;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;

public abstract class AbstractPrimitiveService<C>
implements PrimitiveService {
    private final PrimitiveType primitiveType;
    private final Class<C> clientInterface;
    private final Serializer serializer;
    private Logger log;
    private ServiceContext context;
    private ServiceExecutor executor;
    private final Map<SessionId, Session<C>> sessions = Maps.newHashMap();

    protected AbstractPrimitiveService(PrimitiveType primitiveType) {
        this(primitiveType, null);
    }

    protected AbstractPrimitiveService(PrimitiveType primitiveType, Class<C> clientInterface) {
        this.primitiveType = primitiveType;
        this.clientInterface = clientInterface;
        this.serializer = Serializer.using((Namespace)primitiveType.namespace());
    }

    @Override
    public Serializer serializer() {
        return this.serializer;
    }

    protected <T> byte[] encode(T object) {
        return object != null ? this.serializer().encode(object) : null;
    }

    protected <T> T decode(byte[] bytes) {
        return (T)(bytes != null ? this.serializer().decode(bytes) : null);
    }

    @Override
    public final void init(ServiceContext context) {
        this.context = context;
        this.executor = new DefaultServiceExecutor(context, this.serializer());
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(PrimitiveService.class).addValue((Object)context.serviceId()).add("type", (Object)context.serviceType()).add("name", (Object)context.serviceName()).build());
        this.configure(this.executor);
    }

    @Override
    public final void tick(WallClockTimestamp timestamp) {
        this.executor.tick(timestamp);
    }

    @Override
    public final byte[] apply(Commit<byte[]> commit) {
        return this.executor.apply(commit);
    }

    protected void configure(ServiceExecutor executor) {
        Operations.getOperationMap(this.getClass()).forEach((operationId, method) -> this.configure((OperationId)operationId, (Method)method, executor));
    }

    private void configure(OperationId operationId, Method method, ServiceExecutor executor) {
        if (method.getReturnType() == Void.TYPE) {
            if (method.getParameterTypes().length == 0) {
                executor.register(operationId, () -> {
                    try {
                        method.invoke((Object)this, new Object[0]);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new PrimitiveException.ServiceException(e.getMessage());
                    }
                });
            } else {
                executor.register(operationId, args -> {
                    try {
                        method.invoke((Object)this, (Object[])args.value());
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new PrimitiveException.ServiceException(e.getMessage());
                    }
                });
            }
        } else if (method.getParameterTypes().length == 0) {
            executor.register(operationId, () -> {
                try {
                    return method.invoke((Object)this, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new PrimitiveException.ServiceException(e.getMessage());
                }
            });
        } else {
            executor.register(operationId, args -> {
                try {
                    return method.invoke((Object)this, (Object[])args.value());
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new PrimitiveException.ServiceException(e.getMessage());
                }
            });
        }
    }

    protected PrimitiveType getPrimitiveType() {
        return this.primitiveType;
    }

    protected Logger getLogger() {
        return this.log;
    }

    protected Scheduler getScheduler() {
        return this.executor;
    }

    protected PrimitiveId getServiceId() {
        return this.context.serviceId();
    }

    protected String getServiceName() {
        return this.context.serviceName();
    }

    protected long getCurrentIndex() {
        return this.context.currentIndex();
    }

    protected Session<C> getCurrentSession() {
        return this.getSession(this.context.currentSession().sessionId());
    }

    protected Clock getClock() {
        return this.getWallClock();
    }

    protected WallClock getWallClock() {
        return this.context.wallClock();
    }

    protected LogicalClock getLogicalClock() {
        return this.context.logicalClock();
    }

    protected Session<C> getSession(long sessionId) {
        return this.getSession(SessionId.from(sessionId));
    }

    protected Session<C> getSession(SessionId sessionId) {
        return this.sessions.get((Object)sessionId);
    }

    protected Collection<Session<C>> getSessions() {
        return this.sessions.values();
    }

    @Override
    public final void register(Session session) {
        this.sessions.put(session.sessionId(), new ClientSession<C>(this.clientInterface, session));
        this.onOpen(session);
    }

    @Override
    public final void expire(SessionId sessionId) {
        Session<C> session = this.sessions.remove((Object)sessionId);
        if (session != null) {
            this.onExpire(session);
        }
    }

    @Override
    public final void close(SessionId sessionId) {
        Session<C> session = this.sessions.remove((Object)sessionId);
        if (session != null) {
            this.onClose(session);
        }
    }

    protected void onOpen(Session session) {
    }

    protected void onExpire(Session session) {
    }

    protected void onClose(Session session) {
    }
}

