/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import io.airlift.slice.CountingInputStream;
import io.airlift.slice.LittleEndianDataInputStream;
import io.airlift.slice.Preconditions;
import io.airlift.slice.RuntimeIOException;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceStreamUtils;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;

public final class InputStreamSliceInput
extends SliceInput {
    private final PushbackInputStream pushbackInputStream;
    private final CountingInputStream countingInputStream;
    private final LittleEndianDataInputStream dataInputStream;

    public InputStreamSliceInput(InputStream inputStream) {
        Preconditions.checkNotNull(inputStream, "inputStream is null");
        this.pushbackInputStream = new PushbackInputStream(inputStream);
        this.countingInputStream = new CountingInputStream(this.pushbackInputStream);
        this.dataInputStream = new LittleEndianDataInputStream(this.countingInputStream);
    }

    @Override
    public int position() {
        return (int)this.countingInputStream.getCount();
    }

    @Override
    public void setPosition(int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isReadable() {
        try {
            int value = this.pushbackInputStream.read();
            if (value == -1) {
                return false;
            }
            this.pushbackInputStream.unread(value);
            return true;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public int skipBytes(int n) {
        try {
            return this.dataInputStream.skipBytes(n);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public float readFloat() {
        try {
            return this.dataInputStream.readFloat();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public double readDouble() {
        try {
            return this.dataInputStream.readDouble();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public int readUnsignedByte() {
        try {
            return this.dataInputStream.readUnsignedByte();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public int readUnsignedShort() {
        try {
            return this.dataInputStream.readUnsignedShort();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public int readInt() {
        try {
            return this.dataInputStream.readInt();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public long readLong() {
        try {
            return this.dataInputStream.readLong();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public short readShort() {
        try {
            return this.dataInputStream.readShort();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public byte readByte() {
        try {
            return this.dataInputStream.readByte();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public boolean readBoolean() {
        try {
            return this.dataInputStream.readBoolean();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public int read() {
        try {
            return this.dataInputStream.read();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public int read(byte[] b) {
        try {
            return this.dataInputStream.read(b);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) {
        try {
            return this.dataInputStream.read(b, off, len);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public long skip(long n) {
        try {
            return this.dataInputStream.skip(n);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public int available() {
        try {
            return this.countingInputStream.available();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.dataInputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void readBytes(byte[] destination, int destinationIndex, int length) {
        try {
            this.dataInputStream.read(destination, destinationIndex, length);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public Slice readSlice(int length) {
        if (length == 0) {
            return Slices.EMPTY_SLICE;
        }
        try {
            Slice newSlice = Slices.allocate(length);
            newSlice.setBytes(0, this.countingInputStream, length);
            return newSlice;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void readBytes(Slice destination, int destinationIndex, int length) {
        try {
            destination.setBytes(destinationIndex, this.countingInputStream, length);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void readBytes(OutputStream out, int length) throws IOException {
        SliceStreamUtils.copyStream(this, out, length);
    }
}

