/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration;

import com.google.common.collect.ImmutableList;
import com.google.inject.ConfigurationException;
import com.google.inject.spi.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class Problems {
    private final List<Message> errors = new ArrayList<Message>();
    private final List<Message> warnings = new ArrayList<Message>();
    private final Monitor monitor;
    public static final Monitor NULL_MONITOR = new NullMonitor();

    public Problems() {
        this.monitor = NULL_MONITOR;
    }

    public Problems(Monitor monitor) {
        this.monitor = monitor;
    }

    public void throwIfHasErrors() throws ConfigurationException {
        if (!this.errors.isEmpty()) {
            throw this.getException();
        }
    }

    public List<Message> getErrors() {
        return ImmutableList.copyOf(this.errors);
    }

    public void addError(String format, Object ... params) {
        Message message = new Message("Error: " + String.format(format, params));
        this.errors.add(message);
        this.monitor.onError(message);
    }

    public void addError(Throwable e, String format, Object ... params) {
        Message message = new Message(Collections.emptyList(), "Error: " + String.format(format, params), e);
        this.errors.add(message);
        this.monitor.onError(message);
    }

    public List<Message> getWarnings() {
        return ImmutableList.copyOf(this.warnings);
    }

    public void addWarning(String format, Object ... params) {
        Message message = new Message("Warning: " + String.format(format, params));
        this.warnings.add(message);
        this.monitor.onWarning(message);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Message error : this.errors) {
            builder.append(error.getMessage()).append('\n');
        }
        for (Message warning : this.warnings) {
            builder.append(warning.getMessage()).append('\n');
        }
        return builder.toString();
    }

    private ConfigurationException getException() {
        ImmutableList messages = new ImmutableList.Builder().addAll(this.errors).addAll(this.warnings).build();
        return new ConfigurationException((Iterable)messages);
    }

    public static ConfigurationException exceptionFor(String format, Object ... params) {
        Problems problems = new Problems();
        problems.addError(format, params);
        return problems.getException();
    }

    public static ConfigurationException exceptionFor(Throwable e, String format, Object ... params) {
        Problems problems = new Problems();
        problems.addError(e, format, params);
        return problems.getException();
    }

    private static final class NullMonitor
    implements Monitor {
        private NullMonitor() {
        }

        @Override
        public void onError(Message unused) {
        }

        @Override
        public void onWarning(Message unused) {
        }
    }

    public static interface Monitor {
        public void onError(Message var1);

        public void onWarning(Message var1);
    }
}

