/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline.command;

import io.airlift.airline.Cli;
import io.airlift.airline.TestingUtil;
import io.airlift.airline.command.CommandAdd;
import io.airlift.airline.command.CommandCommit;
import java.util.Arrays;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CommandTest {
    @Test
    public void namedCommandTest1() {
        Cli parser = Cli.builder((String)"git").withCommand(CommandAdd.class).withCommand(CommandCommit.class).build();
        Object command = parser.parse(new String[]{"add", "-i", "A.java"});
        Assert.assertNotNull((Object)command, (String)"command is null");
        Assert.assertTrue((boolean)(command instanceof CommandAdd));
        CommandAdd add = (CommandAdd)command;
        Assert.assertEquals((boolean)add.interactive, (boolean)true);
        Assert.assertEquals(add.patterns, Arrays.asList("A.java"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void shouldComplainIfNoAnnotations() {
        TestingUtil.singleCommandParser(String.class);
    }

    @Test
    public void commandTest2() {
        Cli parser = Cli.builder((String)"git").withCommand(CommandAdd.class).withCommand(CommandCommit.class).build();
        parser.parse(new String[]{"-v", "commit", "--amend", "--author", "cbeust", "A.java", "B.java"});
        Object command = parser.parse(new String[]{"-v", "commit", "--amend", "--author", "cbeust", "A.java", "B.java"});
        Assert.assertNotNull((Object)command, (String)"command is null");
        Assert.assertTrue((boolean)(command instanceof CommandCommit));
        CommandCommit commit = (CommandCommit)command;
        Assert.assertTrue((boolean)commit.commandMain.verbose);
        Assert.assertTrue((boolean)commit.amend);
        Assert.assertEquals((String)commit.author, (String)"cbeust");
        Assert.assertEquals(commit.files, Arrays.asList("A.java", "B.java"));
    }
}

