/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.airlift.airline.Arguments;
import io.airlift.airline.Cli;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import io.airlift.airline.TestingUtil;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestParametersDelegate {
    @Test
    public void delegatingEmptyClassHasNoEffect() {
        DelegatingEmptyClassHasNoEffect p = (DelegatingEmptyClassHasNoEffect)Cli.builder((String)"foo").withCommand(DelegatingEmptyClassHasNoEffect.class).build().parse(new String[]{"command", "-a", "-b", "someValue"});
        Assert.assertTrue((boolean)p.isA);
        Assert.assertEquals((String)p.bValue, (String)"someValue");
        Assert.assertEquals((String)p.delegate.nonParamString, (String)"a");
    }

    @Test
    public void delegatingSetsFieldsOnBothMainParamsAndTheDelegatedParams() {
        DelegatingSetsFieldsOnBothMainParamsAndTheDelegatedParams p = (DelegatingSetsFieldsOnBothMainParamsAndTheDelegatedParams)TestingUtil.singleCommandParser(DelegatingSetsFieldsOnBothMainParamsAndTheDelegatedParams.class).parse(new String[]{"command", "-c", "--long-d", "123", "--long-b", "bValue"});
        Assert.assertFalse((boolean)p.isA);
        Assert.assertEquals((String)p.bValue, (String)"bValue");
        Assert.assertTrue((boolean)p.delegate.isC);
        Assert.assertEquals((Object)p.delegate.d, (Object)123);
    }

    @Test
    public void combinedAndNestedDelegates() {
        CombinedAndNestedDelegates p = (CombinedAndNestedDelegates)TestingUtil.singleCommandParser(CombinedAndNestedDelegates.class).parse(new String[]{"command", "-d", "234", "--list", "a", "--list", "b", "-a"});
        Assert.assertEquals(p.nestedDelegate2.nestedDelegate1.leafDelegate.list, (Collection)Lists.newArrayList((Object[])new String[]{"value1", "value2", "a", "b"}));
        Assert.assertFalse((boolean)p.nestedDelegate2.nestedDelegate1.leafDelegate.bool);
        Assert.assertEquals((Object)p.nestedDelegate2.nestedDelegate1.d, (Object)234);
        Assert.assertFalse((boolean)p.nestedDelegate2.isC);
        Assert.assertTrue((boolean)p.isA);
        Assert.assertEquals((String)p.bValue, (String)"");
    }

    @Test
    public void commandTest() {
        CommandTest c = (CommandTest)TestingUtil.singleCommandParser(CommandTest.class).parse(new String[]{"command", "-a", "a"});
        Assert.assertEquals((String)c.delegate.a, (String)"a");
    }

    @Test
    public void nullDelegatesAreAllowed() {
        NullDelegatesAreProhibited value = (NullDelegatesAreProhibited)TestingUtil.singleCommandParser(NullDelegatesAreProhibited.class).parse(new String[]{"command", "-a"});
        Assert.assertEquals((boolean)value.delegate.a, (boolean)true);
    }

    @Test
    public void duplicateDelegateAllowed() {
        DuplicateDelegateAllowed value = (DuplicateDelegateAllowed)TestingUtil.singleCommandParser(DuplicateDelegateAllowed.class).parse(new String[]{"command", "-a", "value"});
        Assert.assertEquals((String)value.d1.a, (String)"value");
        Assert.assertEquals((String)value.d2.a, (String)"value");
    }

    @Test
    public void duplicateMainParametersAreAllowed() {
        DuplicateMainParametersAreAllowed value = (DuplicateMainParametersAreAllowed)TestingUtil.singleCommandParser(DuplicateMainParametersAreAllowed.class).parse(new String[]{"command", "main", "params"});
        Assert.assertEquals(value.delegate1.mainParams1, (Collection)ImmutableList.of((Object)"main", (Object)"params"));
        Assert.assertEquals(value.delegate2.mainParams1, (Collection)ImmutableList.of((Object)"main", (Object)"params"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void conflictingMainParametersAreNotAllowed() {
        TestingUtil.singleCommandParser(ConflictingMainParametersAreNotAllowed.class).parse(new String[]{"command", "main", "params"});
    }

    @Command(name="command")
    public static class ConflictingMainParametersAreNotAllowed {
        @Inject
        public Delegate1 delegate1 = new Delegate1();
        @Inject
        public Delegate2 delegate2 = new Delegate2();

        public static class Delegate2 {
            @Arguments(description="bar")
            public List<String> mainParams1 = Lists.newArrayList();
        }

        public static class Delegate1 {
            @Arguments(description="foo")
            public List<String> mainParams1 = Lists.newArrayList();
        }
    }

    @Command(name="command")
    public static class DuplicateMainParametersAreAllowed {
        @Inject
        public Delegate1 delegate1 = new Delegate1();
        @Inject
        public Delegate2 delegate2 = new Delegate2();

        public static class Delegate2 {
            @Arguments
            public List<String> mainParams1 = Lists.newArrayList();
        }

        public static class Delegate1 {
            @Arguments
            public List<String> mainParams1 = Lists.newArrayList();
        }
    }

    @Command(name="command")
    public static class DuplicateDelegateAllowed {
        @Inject
        public Delegate d1 = new Delegate();
        @Inject
        public Delegate d2 = new Delegate();

        public static class Delegate {
            @Option(name={"-a"})
            public String a;
        }
    }

    @Command(name="command")
    public static class NullDelegatesAreProhibited {
        @Inject
        public ComplexDelegate delegate;

        public static class ComplexDelegate {
            @Option(name={"-a"})
            public boolean a;
        }
    }

    @Command(name="command")
    public static class CommandTest {
        @Inject
        public Delegate delegate = new Delegate();

        public static class Delegate {
            @Option(name={"-a"})
            public String a = "b";
        }
    }

    @Command(name="command")
    public static class CombinedAndNestedDelegates {
        @Option(name={"-a"})
        public boolean isA;
        @Option(name={"-b", "--long-b"})
        public String bValue = "";
        @Inject
        public NestedDelegate2 nestedDelegate2 = new NestedDelegate2();

        public static class NestedDelegate2 {
            @Option(name={"-c"})
            public boolean isC;
            @Inject
            public NestedDelegate1 nestedDelegate1 = new NestedDelegate1();
        }

        public static class NestedDelegate1 {
            @Inject
            public LeafDelegate leafDelegate = new LeafDelegate();
            @Option(name={"-d", "--long-d"})
            public Integer d;
        }

        public static class LeafDelegate {
            @Option(name={"--list"})
            public List<String> list = Lists.newArrayList((Object[])new String[]{"value1", "value2"});
            @Option(name={"--bool"})
            public boolean bool;
        }
    }

    @Command(name="command")
    public static class DelegatingSetsFieldsOnBothMainParamsAndTheDelegatedParams {
        @Option(name={"-a"})
        public boolean isA;
        @Option(name={"-b", "--long-b"})
        public String bValue = "";
        @Inject
        public ComplexDelegate delegate = new ComplexDelegate();

        public static class ComplexDelegate {
            @Option(name={"-c"})
            public boolean isC;
            @Option(name={"-d", "--long-d"})
            public Integer d;
        }
    }

    @Command(name="command")
    public static class DelegatingEmptyClassHasNoEffect {
        @Option(name={"-a"})
        public boolean isA;
        @Option(name={"-b", "--long-b"})
        public String bValue = "";
        @Inject
        public EmptyDelegate delegate = new EmptyDelegate();

        public static class EmptyDelegate {
            public String nonParamString = "a";
        }
    }
}

