/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline;

import com.google.common.collect.ImmutableList;
import io.airlift.airline.Cli;
import io.airlift.airline.CommandUsage;
import io.airlift.airline.Git;
import io.airlift.airline.Help;
import io.airlift.airline.SingleCommand;
import io.airlift.airline.args.Args1;
import io.airlift.airline.args.Args2;
import io.airlift.airline.args.ArgsArityString;
import io.airlift.airline.args.ArgsBooleanArity;
import io.airlift.airline.args.ArgsInherited;
import io.airlift.airline.args.ArgsRequired;
import io.airlift.airline.args.CommandHidden;
import io.airlift.airline.args.OptionsHidden;
import io.airlift.airline.args.OptionsRequired;
import io.airlift.airline.model.GlobalMetadata;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class TestHelp {
    @Test
    public void testGit() {
        Cli.CliBuilder builder = Cli.builder((String)"git").withDescription("the stupid content tracker").withDefaultCommand(Help.class).withCommand(Help.class).withCommand(Git.Add.class);
        builder.withGroup("remote").withDescription("Manage set of tracked repositories").withDefaultCommand(Git.RemoteShow.class).withCommand(Git.RemoteShow.class).withCommand(Git.RemoteAdd.class);
        Cli gitParser = builder.build();
        StringBuilder out = new StringBuilder();
        Help.help((GlobalMetadata)gitParser.getMetadata(), (List)ImmutableList.of(), (StringBuilder)out);
        Assert.assertEquals((String)out.toString(), (String)"usage: git [-v] <command> [<args>]\n\nThe most commonly used git commands are:\n    add      Add file contents to the index\n    help     Display help information\n    remote   Manage set of tracked repositories\n\nSee 'git help <command>' for more information on a specific command.\n");
        out = new StringBuilder();
        Help.help((GlobalMetadata)gitParser.getMetadata(), (List)ImmutableList.of((Object)"add"), (StringBuilder)out);
        Assert.assertEquals((String)out.toString(), (String)"NAME\n        git add - Add file contents to the index\n\nSYNOPSIS\n        git [-v] add [-i] [--] [<patterns>...]\n\nOPTIONS\n        -i\n            Add modified contents interactively.\n\n        -v\n            Verbose mode\n\n        --\n            This option can be used to separate command-line options from the\n            list of argument, (useful when arguments might be mistaken for\n            command-line options\n\n        <patterns>\n            Patterns of files to be added\n\n");
        out = new StringBuilder();
        Help.help((GlobalMetadata)gitParser.getMetadata(), (List)ImmutableList.of((Object)"remote"), (StringBuilder)out);
        Assert.assertEquals((String)out.toString(), (String)"NAME\n        git remote - Manage set of tracked repositories\n\nSYNOPSIS\n        git [-v] remote\n        git [-v] remote add [-t <branch>]\n        git [-v] remote show [-n]\n\nOPTIONS\n        -v\n            Verbose mode\n\nCOMMANDS\n        With no arguments, Gives some information about the remote <name>\n\n        show\n            Gives some information about the remote <name>\n\n            With -n option, Do not query remote heads\n\n        add\n            Adds a remote\n\n            With -t option, Track only a specific branch\n\n");
    }

    @Test
    public void testArgs1() {
        Cli.CliBuilder builder = Cli.builder((String)"test").withDescription("Test commandline").withDefaultCommand(Help.class).withCommands(Help.class, new Class[]{Args1.class});
        Cli parser = builder.build();
        StringBuilder out = new StringBuilder();
        Help.help((GlobalMetadata)parser.getMetadata(), (List)ImmutableList.of((Object)"Args1"), (StringBuilder)out);
        Assert.assertEquals((String)out.toString(), (String)"NAME\n        test Args1 - args1 description\n\nSYNOPSIS\n        test Args1 [-bigdecimal <bigd>] [-date <date>] [-debug] [-double <doub>]\n                [-float <floa>] [-groups <groups>]\n                [(-log <verbose> | -verbose <verbose>)] [-long <l>] [--]\n                [<parameters>...]\n\nOPTIONS\n        -bigdecimal <bigd>\n            A BigDecimal number\n\n        -date <date>\n            An ISO 8601 formatted date.\n\n        -debug\n            Debug mode\n\n        -double <doub>\n            A double number\n\n        -float <floa>\n            A float number\n\n        -groups <groups>\n            Comma-separated list of group names to be run\n\n        -log <verbose>, -verbose <verbose>\n            Level of verbosity\n\n        -long <l>\n            A long number\n\n        --\n            This option can be used to separate command-line options from the\n            list of argument, (useful when arguments might be mistaken for\n            command-line options\n\n        <parameters>\n\n\n");
    }

    @Test
    public void testArgs2() {
        Cli.CliBuilder builder = Cli.builder((String)"test").withDescription("Test commandline").withDefaultCommand(Help.class).withCommands(Help.class, new Class[]{Args2.class});
        Cli parser = builder.build();
        StringBuilder out = new StringBuilder();
        Help.help((GlobalMetadata)parser.getMetadata(), (List)ImmutableList.of((Object)"Args2"), (StringBuilder)out);
        Assert.assertEquals((String)out.toString(), (String)"NAME\n        test Args2 -\n\nSYNOPSIS\n        test Args2 [-debug] [-groups <groups>] [-host <hosts>...]\n                [(-log <verbose> | -verbose <verbose>)] [--] [<parameters>...]\n\nOPTIONS\n        -debug\n            Debug mode\n\n        -groups <groups>\n            Comma-separated list of group names to be run\n\n        -host <hosts>\n            The host\n\n        -log <verbose>, -verbose <verbose>\n            Level of verbosity\n\n        --\n            This option can be used to separate command-line options from the\n            list of argument, (useful when arguments might be mistaken for\n            command-line options\n\n        <parameters>\n            List of parameters\n\n");
    }

    @Test
    public void testArgsAritySting() {
        Cli.CliBuilder builder = Cli.builder((String)"test").withDescription("Test commandline").withDefaultCommand(Help.class).withCommands(Help.class, new Class[]{ArgsArityString.class});
        Cli parser = builder.build();
        StringBuilder out = new StringBuilder();
        Help.help((GlobalMetadata)parser.getMetadata(), (List)ImmutableList.of((Object)"ArgsArityString"), (StringBuilder)out);
        Assert.assertEquals((String)out.toString(), (String)"NAME\n        test ArgsArityString -\n\nSYNOPSIS\n        test ArgsArityString [-pairs <pairs>...] [--] [<rest>...]\n\nOPTIONS\n        -pairs <pairs>\n            Pairs\n\n        --\n            This option can be used to separate command-line options from the\n            list of argument, (useful when arguments might be mistaken for\n            command-line options\n\n        <rest>\n            Rest\n\n");
    }

    @Test
    public void testArgsBooleanArity() {
        Cli.CliBuilder builder = Cli.builder((String)"test").withDescription("Test commandline").withDefaultCommand(Help.class).withCommands(Help.class, new Class[]{ArgsBooleanArity.class});
        Cli parser = builder.build();
        StringBuilder out = new StringBuilder();
        Help.help((GlobalMetadata)parser.getMetadata(), (List)ImmutableList.of((Object)"ArgsBooleanArity"), (StringBuilder)out);
        Assert.assertEquals((String)out.toString(), (String)"NAME\n        test ArgsBooleanArity -\n\nSYNOPSIS\n        test ArgsBooleanArity [-debug <debug>]\n\nOPTIONS\n        -debug <debug>\n\n\n");
    }

    @Test
    public void testArgsInherited() {
        Cli.CliBuilder builder = Cli.builder((String)"test").withDescription("Test commandline").withDefaultCommand(Help.class).withCommands(Help.class, new Class[]{ArgsInherited.class});
        Cli parser = builder.build();
        StringBuilder out = new StringBuilder();
        Help.help((GlobalMetadata)parser.getMetadata(), (List)ImmutableList.of((Object)"ArgsInherited"), (StringBuilder)out);
        Assert.assertEquals((String)out.toString(), (String)"NAME\n        test ArgsInherited -\n\nSYNOPSIS\n        test ArgsInherited [-child <child>] [-debug] [-groups <groups>]\n                [-level <level>] [-log <log>] [--] [<parameters>...]\n\nOPTIONS\n        -child <child>\n            Child parameter\n\n        -debug\n            Debug mode\n\n        -groups <groups>\n            Comma-separated list of group names to be run\n\n        -level <level>\n            A long number\n\n        -log <log>\n            Level of verbosity\n\n        --\n            This option can be used to separate command-line options from the\n            list of argument, (useful when arguments might be mistaken for\n            command-line options\n\n        <parameters>\n\n\n");
    }

    @Test
    public void testArgsRequired() {
        Cli.CliBuilder builder = Cli.builder((String)"test").withDescription("Test commandline").withDefaultCommand(Help.class).withCommands(Help.class, new Class[]{ArgsRequired.class});
        Cli parser = builder.build();
        StringBuilder out = new StringBuilder();
        Help.help((GlobalMetadata)parser.getMetadata(), (List)ImmutableList.of((Object)"ArgsRequired"), (StringBuilder)out);
        Assert.assertEquals((String)out.toString(), (String)"NAME\n        test ArgsRequired -\n\nSYNOPSIS\n        test ArgsRequired [--] <parameters>...\n\nOPTIONS\n        --\n            This option can be used to separate command-line options from the\n            list of argument, (useful when arguments might be mistaken for\n            command-line options\n\n        <parameters>\n            List of files\n\n");
    }

    @Test
    public void testOptionsRequired() {
        Cli.CliBuilder builder = Cli.builder((String)"test").withDescription("Test commandline").withDefaultCommand(Help.class).withCommands(Help.class, new Class[]{OptionsRequired.class});
        Cli parser = builder.build();
        StringBuilder out = new StringBuilder();
        Help.help((GlobalMetadata)parser.getMetadata(), (List)ImmutableList.of((Object)"OptionsRequired"), (StringBuilder)out);
        Assert.assertEquals((String)out.toString(), (String)"NAME\n        test OptionsRequired -\n\nSYNOPSIS\n        test OptionsRequired [--optional <optionalOption>]\n                --required <requiredOption>\n\nOPTIONS\n        --optional <optionalOption>\n\n\n        --required <requiredOption>\n\n\n");
    }

    @Test
    public void testOptionsHidden() {
        Cli.CliBuilder builder = Cli.builder((String)"test").withDescription("Test commandline").withDefaultCommand(Help.class).withCommands(Help.class, new Class[]{OptionsHidden.class});
        Cli parser = builder.build();
        StringBuilder out = new StringBuilder();
        Help.help((GlobalMetadata)parser.getMetadata(), (List)ImmutableList.of((Object)"OptionsHidden"), (StringBuilder)out);
        Assert.assertEquals((String)out.toString(), (String)"NAME\n        test OptionsHidden -\n\nSYNOPSIS\n        test OptionsHidden [--optional <optionalOption>]\n\nOPTIONS\n        --optional <optionalOption>\n\n\n");
    }

    @Test
    public void testCommandHidden() {
        Cli.CliBuilder builder = Cli.builder((String)"test").withDescription("Test commandline").withDefaultCommand(Help.class).withCommands(Help.class, new Class[]{ArgsRequired.class, CommandHidden.class});
        Cli parser = builder.build();
        StringBuilder out = new StringBuilder();
        Help.help((GlobalMetadata)parser.getMetadata(), (List)ImmutableList.of(), (StringBuilder)out);
        Assert.assertEquals((String)out.toString(), (String)"usage: test <command> [<args>]\n\nThe most commonly used test commands are:\n    ArgsRequired\n    help           Display help information\n\nSee 'test help <command>' for more information on a specific command.\n");
        out = new StringBuilder();
        Help.help((GlobalMetadata)parser.getMetadata(), (List)ImmutableList.of((Object)"CommandHidden"), (StringBuilder)out);
        Assert.assertEquals((String)out.toString(), (String)"NAME\n        test CommandHidden -\n\nSYNOPSIS\n        test CommandHidden [--optional <optionalOption>]\n\nOPTIONS\n        --optional <optionalOption>\n\n\n");
    }

    @Test
    public void testSingleCommandArgs1() {
        SingleCommand command = SingleCommand.singleCommand(Args1.class);
        StringBuilder out = new StringBuilder();
        new CommandUsage().usage(null, null, "test", command.getCommandMetadata(), out);
        Assert.assertEquals((String)out.toString(), (String)"NAME\n        test - args1 description\n\nSYNOPSIS\n        test [-bigdecimal <bigd>] [-date <date>] [-debug] [-double <doub>]\n                [-float <floa>] [-groups <groups>]\n                [(-log <verbose> | -verbose <verbose>)] [-long <l>] [--]\n                [<parameters>...]\n\nOPTIONS\n        -bigdecimal <bigd>\n            A BigDecimal number\n\n        -date <date>\n            An ISO 8601 formatted date.\n\n        -debug\n            Debug mode\n\n        -double <doub>\n            A double number\n\n        -float <floa>\n            A float number\n\n        -groups <groups>\n            Comma-separated list of group names to be run\n\n        -log <verbose>, -verbose <verbose>\n            Level of verbosity\n\n        -long <l>\n            A long number\n\n        --\n            This option can be used to separate command-line options from the\n            list of argument, (useful when arguments might be mistaken for\n            command-line options\n\n        <parameters>\n\n\n");
    }
}

