/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.airline;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import io.airlift.airline.Arguments;
import io.airlift.airline.Cli;
import io.airlift.airline.Command;
import io.airlift.airline.Help;
import io.airlift.airline.Option;
import io.airlift.airline.OptionType;
import java.util.List;
import javax.inject.Inject;
import org.testng.annotations.Test;

public class TestGalaxyCommandLineParser {
    @Test
    public void test() {
        this.parse(new String[0]);
        this.parse("help");
        this.parse("help", "galaxy");
        this.parse("help", "show");
        this.parse("help", "install");
        this.parse("help", "upgrade");
        this.parse("help", "upgrade");
        this.parse("help", "terminate");
        this.parse("help", "start");
        this.parse("help", "stop");
        this.parse("help", "restart");
        this.parse("help", "reset-to-actual");
        this.parse("help", "ssh");
        this.parse("help", "agent");
        this.parse("help", "agent", "show");
        this.parse("help", "agent", "add");
        this.parse("--debug", "show", "-u", "b2", "--state", "r");
        this.parse("--debug", "install", "com.proofpoint.discovery:discovery-server:1.1", "@discovery:general:1.0");
        this.parse("--debug", "upgrade", "-u", "b2", "1.1", "@1.0");
        this.parse("--debug", "upgrade", "-u", "b2", "1.1", "@1.0", "-s", "r");
        this.parse("--debug", "terminate", "-u", "b2");
        this.parse("--debug", "start", "-u", "b2");
        this.parse("--debug", "stop", "-u", "b2");
        this.parse("--debug", "restart", "-u", "b2");
        this.parse("--debug", "reset-to-actual", "-u", "b2");
        this.parse("--debug", "ssh");
        this.parse("--debug", "ssh", "-u", "b2", "--state", "r", "tail -F var/log/launcher.log");
        this.parse("--debug", "agent");
        this.parse("--debug", "agent", "show");
        this.parse("--debug", "agent", "add", "--count", "4", "t1.micro");
    }

    private Cli<GalaxyCommand> createParser() {
        Cli.CliBuilder builder = Cli.builder((String)"galaxy").withDescription("cloud management system").withDefaultCommand(HelpCommand.class).withCommand(HelpCommand.class).withCommand(ShowCommand.class).withCommand(InstallCommand.class).withCommand(UpgradeCommand.class).withCommand(TerminateCommand.class).withCommand(StartCommand.class).withCommand(StopCommand.class).withCommand(RestartCommand.class).withCommand(SshCommand.class).withCommand(ResetToActualCommand.class);
        builder.withGroup("agent").withDescription("Manage agents").withDefaultCommand(AgentShowCommand.class).withCommand(AgentShowCommand.class).withCommand(AgentAddCommand.class).withCommand(AgentTerminateCommand.class);
        return builder.build();
    }

    private void parse(String ... args) {
        System.out.println("$ galaxy " + Joiner.on((String)" ").join((Object[])args));
        GalaxyCommand command = (GalaxyCommand)this.createParser().parse(args);
        command.execute();
        System.out.println();
    }

    @Command(name="terminate", description="Provision a new agent")
    public static class AgentTerminateCommand
    extends GalaxyCommand {
        @Arguments(title="agent-id", description="Agent to terminate", required=true)
        public String agentId;

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("agentId", (Object)this.agentId).add("globalOptions", (Object)this.globalOptions).toString();
        }
    }

    @Command(name="show", description="Show agent details")
    public static class AgentShowCommand
    extends GalaxyCommand {
        @Inject
        public final AgentFilter agentFilter = new AgentFilter();

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("agentFilter", (Object)this.agentFilter).add("globalOptions", (Object)this.globalOptions).toString();
        }
    }

    @Command(name="add", description="Provision a new agent")
    public static class AgentAddCommand
    extends GalaxyCommand {
        @Option(name={"--count"}, description="Number of agents to provision")
        public int count = 1;
        @Option(name={"--availability-zone"}, description="Availability zone to provision")
        public String availabilityZone;
        @Arguments(usage="[<instance-type>]", description="Instance type to provision")
        public String instanceType;

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("count", this.count).add("availabilityZone", (Object)this.availabilityZone).add("instanceType", (Object)this.instanceType).add("globalOptions", (Object)this.globalOptions).toString();
        }
    }

    @Command(name="ssh", description="ssh to slot installation")
    public static class SshCommand
    extends GalaxyCommand {
        @Inject
        public final SlotFilter slotFilter = new SlotFilter();
        @Arguments(description="Command to execute on the remote host")
        public String command;

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("slotFilter", (Object)this.slotFilter).add("command", (Object)this.command).toString();
        }
    }

    @Command(name="reset-to-actual", description="Reset slot expected state to actual")
    public static class ResetToActualCommand
    extends GalaxyCommand {
        @Inject
        public final SlotFilter slotFilter = new SlotFilter();

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("slotFilter", (Object)this.slotFilter).add("globalOptions", (Object)this.globalOptions).toString();
        }
    }

    @Command(name="restart", description="Restart server")
    public static class RestartCommand
    extends GalaxyCommand {
        @Inject
        public final SlotFilter slotFilter = new SlotFilter();

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("slotFilter", (Object)this.slotFilter).add("globalOptions", (Object)this.globalOptions).toString();
        }
    }

    @Command(name="stop", description="Stop a server")
    public static class StopCommand
    extends GalaxyCommand {
        @Inject
        public final SlotFilter slotFilter = new SlotFilter();

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("slotFilter", (Object)this.slotFilter).add("globalOptions", (Object)this.globalOptions).toString();
        }
    }

    @Command(name="start", description="Start a server")
    public static class StartCommand
    extends GalaxyCommand {
        @Inject
        public final SlotFilter slotFilter = new SlotFilter();

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("slotFilter", (Object)this.slotFilter).add("globalOptions", (Object)this.globalOptions).toString();
        }
    }

    @Command(name="terminate", description="Terminate (remove) a slot")
    public static class TerminateCommand
    extends GalaxyCommand {
        @Inject
        public final SlotFilter slotFilter = new SlotFilter();

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("slotFilter", (Object)this.slotFilter).add("globalOptions", (Object)this.globalOptions).toString();
        }
    }

    @Command(name="upgrade", description="Upgrade software in a slot")
    public static class UpgradeCommand
    extends GalaxyCommand {
        @Inject
        public final SlotFilter slotFilter = new SlotFilter();
        @Arguments(usage="[<binary-version>] [@<config-version>]", description="Version of the binary and/or @configuration")
        public final List<String> versions = Lists.newArrayList();

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("slotFilter", (Object)this.slotFilter).add("versions", this.versions).add("globalOptions", (Object)this.globalOptions).toString();
        }
    }

    @Command(name="install", description="Install software in a new slot")
    public static class InstallCommand
    extends GalaxyCommand {
        @Option(name={"--count"}, description="Number of instances to install")
        public int count = 1;
        @Inject
        public final AgentFilter agentFilter = new AgentFilter();
        @Arguments(usage="<groupId:artifactId[:packaging[:classifier]]:version> @<component:pools:version>", description="The binary and @configuration to install.  The default packaging is tar.gz")
        public final List<String> assignment = Lists.newArrayList();

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("count", this.count).add("agentFilter", (Object)this.agentFilter).add("assignment", this.assignment).add("globalOptions", (Object)this.globalOptions).toString();
        }
    }

    @Command(name="show", description="Show state of all slots")
    public static class ShowCommand
    extends GalaxyCommand {
        @Inject
        public final SlotFilter slotFilter = new SlotFilter();

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("slotFilter", (Object)this.slotFilter).add("globalOptions", (Object)this.globalOptions).toString();
        }
    }

    @Command(name="help", description="Display help information about galaxy")
    public static class HelpCommand
    extends GalaxyCommand {
        @Inject
        public Help help;

        @Override
        public void execute() {
            this.help.call();
        }
    }

    public static abstract class GalaxyCommand {
        @Inject
        public GlobalOptions globalOptions = new GlobalOptions();

        public void execute() {
            System.out.println(this);
        }
    }

    public static class AgentFilter {
        @Option(name={"-i", "--host"}, description="Select slots on the given host")
        public final List<String> host = Lists.newArrayList();
        @Option(name={"-I", "--ip"}, description="Select slots at the given IP address")
        public final List<String> ip = Lists.newArrayList();
        @Option(name={"-u", "--uuid"}, description="Select slot with the given UUID")
        public final List<String> uuid = Lists.newArrayList();
        @Option(name={"-s", "--state"}, description="Select 'r{unning}', 's{topped}' or 'unknown' slots")
        public final List<String> state = Lists.newArrayList();

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("host", this.host).add("ip", this.ip).add("uuid", this.uuid).add("state", this.state).toString();
        }
    }

    public static class SlotFilter {
        @Option(name={"-b", "--binary"}, description="Select slots with a given binary")
        public List<String> binary;
        @Option(name={"-c", "--config"}, description="Select slots with a given configuration")
        public List<String> config;
        @Option(name={"-i", "--host"}, description="Select slots on the given host")
        public List<String> host;
        @Option(name={"-I", "--ip"}, description="Select slots at the given IP address")
        public List<String> ip;
        @Option(name={"-u", "--uuid"}, description="Select slot with the given UUID")
        public List<String> uuid;
        @Option(name={"-s", "--state"}, description="Select 'r{unning}', 's{topped}' or 'unknown' slots")
        public List<String> state;

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("binary", this.binary).add("config", this.config).add("host", this.host).add("ip", this.ip).add("uuid", this.uuid).add("state", this.state).toString();
        }
    }

    public static class GlobalOptions {
        @Option(type=OptionType.GLOBAL, name={"--debug"}, description="Enable debug messages")
        public boolean debug = false;
        @Option(type=OptionType.GLOBAL, name={"--coordinator"}, description="Galaxy coordinator host (overrides GALAXY_COORDINATOR)")
        public String coordinator = (String)MoreObjects.firstNonNull((Object)System.getenv("GALAXY_COORDINATOR"), (Object)"http://localhost:64000");

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("debug", this.debug).add("coordinator", (Object)this.coordinator).toString();
        }
    }
}

